/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class DockerContextGenerator {
    private static final String DEPENDENCIES_LAYER_DIRECTORY = "libs";
    private static final String SNAPSHOT_DEPENDENCIES_LAYER_DIRECTORY = "snapshot-libs";
    private static final String RESOURCES_LAYER_DIRECTORY = "resources";
    private static final String CLASSES_LAYER_DIRECTORY = "classes";
    private static final String EXTRA_FILES_LAYER_DIRECTORY = "root";
    private final ImmutableList<CopyDirective> copyDirectives;
    @Nullable
    private String baseImage;
    private List<String> jvmFlags = Collections.emptyList();
    private String mainClass = "";
    private List<String> javaArguments = Collections.emptyList();
    private List<String> exposedPorts = Collections.emptyList();

    private static void addIfNotEmpty(ImmutableList.Builder<CopyDirective> listBuilder, LayerEntry layerEntry, String directoryInContext) {
        if (layerEntry.getSourceFiles().isEmpty()) {
            return;
        }
        listBuilder.add((Object)new CopyDirective(layerEntry.getSourceFiles(), directoryInContext, layerEntry.getExtractionPath()));
    }

    public DockerContextGenerator(LayerEntry dependenciesLayerEntry, LayerEntry snapshotDependenciesLayerEntry, LayerEntry resourcesLayerEntry, LayerEntry classesLayerEntry, LayerEntry extraFilesLayerEntry) {
        ImmutableList.Builder copyDirectivesBuilder = ImmutableList.builder();
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, dependenciesLayerEntry, DEPENDENCIES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, snapshotDependenciesLayerEntry, SNAPSHOT_DEPENDENCIES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, resourcesLayerEntry, RESOURCES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, classesLayerEntry, CLASSES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, extraFilesLayerEntry, EXTRA_FILES_LAYER_DIRECTORY);
        this.copyDirectives = copyDirectivesBuilder.build();
    }

    public DockerContextGenerator setBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return this;
    }

    public DockerContextGenerator setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
        return this;
    }

    public DockerContextGenerator setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public DockerContextGenerator setJavaArguments(List<String> javaArguments) {
        this.javaArguments = javaArguments;
        return this;
    }

    public DockerContextGenerator setExposedPorts(List<String> exposedPorts) {
        this.exposedPorts = exposedPorts;
        return this;
    }

    public void generate(Path targetDirectory) throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        try {
            Files.deleteIfExists(targetDirectory);
        }
        catch (DirectoryNotEmptyException ex) {
            MoreFiles.deleteDirectoryContents((Path)targetDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            Files.delete(targetDirectory);
        }
        Files.createDirectory(targetDirectory, new FileAttribute[0]);
        for (CopyDirective copyDirective : this.copyDirectives) {
            Path directoryInContext = targetDirectory.resolve(copyDirective.directoryInContext);
            Files.createDirectory(directoryInContext, new FileAttribute[0]);
            FileOperations.copy((ImmutableList<Path>)copyDirective.sourceFiles, directoryInContext);
        }
        Files.write(targetDirectory.resolve("Dockerfile"), this.makeDockerfile().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    String makeDockerfile() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        StringBuilder dockerfile = new StringBuilder();
        dockerfile.append("FROM ").append((String)Preconditions.checkNotNull((Object)this.baseImage)).append("\n");
        for (CopyDirective copyDirective : this.copyDirectives) {
            dockerfile.append("\nCOPY ").append(copyDirective.directoryInContext).append(" ").append(copyDirective.extractionPath);
        }
        dockerfile.append("\n");
        for (String port : this.exposedPorts) {
            dockerfile.append("\nEXPOSE ").append(port);
        }
        dockerfile.append("\nENTRYPOINT ").append(objectMapper.writeValueAsString(JavaEntrypointConstructor.makeDefaultEntrypoint(this.jvmFlags, this.mainClass))).append("\nCMD ").append(objectMapper.writeValueAsString(this.javaArguments));
        return dockerfile.toString();
    }

    private static class CopyDirective {
        private final ImmutableList<Path> sourceFiles;
        private final String directoryInContext;
        private final String extractionPath;

        private CopyDirective(ImmutableList<Path> sourceFiles, String directoryInContext, String extractionPath) {
            this.sourceFiles = sourceFiles;
            this.directoryInContext = directoryInContext;
            this.extractionPath = extractionPath;
        }
    }
}

