/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.builder.BuildSteps;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.apache.http.conn.HttpHostConnectException;

public class BuildStepsRunner {
    private final BuildSteps buildSteps;

    public static BuildStepsRunner forBuildImage(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerRegistry(buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    public static BuildStepsRunner forBuildToDockerDaemon(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerDaemon(buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    public static BuildStepsRunner forBuildTar(Path outputPath, BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToTar(outputPath, buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    private static Caches.Initializer getCacheInitializer(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        CacheConfiguration applicationLayersCacheConfiguration = buildConfiguration.getApplicationLayersCacheConfiguration() == null ? CacheConfiguration.makeTemporary() : buildConfiguration.getApplicationLayersCacheConfiguration();
        CacheConfiguration baseImageLayersCacheConfiguration = buildConfiguration.getBaseImageLayersCacheConfiguration() == null ? CacheConfiguration.forDefaultUserLevelCacheDirectory() : buildConfiguration.getBaseImageLayersCacheConfiguration();
        return new Caches.Initializer(baseImageLayersCacheConfiguration.getCacheDirectory(), applicationLayersCacheConfiguration.shouldEnsureOwnership(), applicationLayersCacheConfiguration.getCacheDirectory(), applicationLayersCacheConfiguration.shouldEnsureOwnership());
    }

    private static void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, BuildConfiguration buildConfiguration, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        boolean areTargetImageCredentialsConfigured;
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpStatusCodeForbidden(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
        }
        boolean isImageForBase = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getBaseImageConfiguration().getImageRegistry()) && registryUnauthorizedException.getRepository().equals(buildConfiguration.getBaseImageConfiguration().getImageRepository());
        boolean isImageForTarget = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getTargetImageConfiguration().getImageRegistry()) && registryUnauthorizedException.getRepository().equals(buildConfiguration.getTargetImageConfiguration().getImageRepository());
        boolean areBaseImageCredentialsConfigured = buildConfiguration.getBaseImageConfiguration().getCredentialHelper() != null || buildConfiguration.getBaseImageConfiguration().getKnownRegistryCredentials() != null;
        boolean bl = areTargetImageCredentialsConfigured = buildConfiguration.getTargetImageConfiguration().getCredentialHelper() != null || buildConfiguration.getTargetImageConfiguration().getKnownRegistryCredentials() != null;
        if (isImageForBase && !areBaseImageCredentialsConfigured) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForBaseImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        if (isImageForTarget && !areTargetImageCredentialsConfigured) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForTargetImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotCorrect(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
    }

    private static String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    @VisibleForTesting
    BuildStepsRunner(BuildSteps buildSteps) {
        this.buildSteps = buildSteps;
    }

    public void build(HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        try {
            JibLogger buildLogger = this.buildSteps.getBuildConfiguration().getBuildLogger();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getStartupMessage());
            buildLogger.info("Containerizing application with the following files:");
            for (LayerConfiguration layerConfiguration : this.buildSteps.getBuildConfiguration().getLayerConfigurations()) {
                buildLogger.info("\t" + BuildStepsRunner.capitalizeFirstLetter(layerConfiguration.getLabel()) + ":");
                for (LayerEntry layerEntry : layerConfiguration.getLayerEntries()) {
                    for (Path sourceFile : layerEntry.getSourceFiles()) {
                        buildLogger.info("\t\t" + sourceFile);
                    }
                }
            }
            this.buildSteps.run();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getSuccessMessage());
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forCacheNeedsClean(), cacheMetadataCorruptedException);
        }
        catch (ExecutionException executionException) {
            BuildConfiguration buildConfiguration = this.buildSteps.getBuildConfiguration();
            Throwable exceptionDuringBuildSteps = executionException.getCause();
            if (exceptionDuringBuildSteps instanceof HttpHostConnectException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forHttpHostConnect(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryUnauthorizedException) {
                BuildStepsRunner.handleRegistryUnauthorizedException((RegistryUnauthorizedException)exceptionDuringBuildSteps, buildConfiguration, helpfulSuggestions);
            }
            if (exceptionDuringBuildSteps instanceof RegistryCredentialsNotSentException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotSent(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryAuthenticationFailedException && exceptionDuringBuildSteps.getCause() instanceof HttpResponseException) {
                BuildStepsRunner.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(buildConfiguration.getTargetImageConfiguration().getImageRegistry(), buildConfiguration.getTargetImageConfiguration().getImageRepository(), (HttpResponseException)exceptionDuringBuildSteps.getCause()), buildConfiguration, helpfulSuggestions);
            }
            if (exceptionDuringBuildSteps instanceof UnknownHostException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forUnknownHost(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof InsecureRegistryException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forInsecureRegistry(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryErrorException) {
                RegistryErrorException registryErrorException = (RegistryErrorException)exceptionDuringBuildSteps;
                String message = (String)Verify.verifyNotNull((Object)registryErrorException.getMessage());
                throw new BuildStepsExecutionException(message, exceptionDuringBuildSteps);
            }
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), executionException.getCause());
        }
        catch (CacheDirectoryCreationException | IOException | InterruptedException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), ex);
        }
        catch (CacheDirectoryNotOwnedException ex) {
            String helpfulSuggestion = helpfulSuggestions.forCacheDirectoryNotOwned(ex.getCacheDirectory());
            CacheConfiguration applicationLayersCacheConfiguration = this.buildSteps.getBuildConfiguration().getApplicationLayersCacheConfiguration();
            if (applicationLayersCacheConfiguration != null && ex.getCacheDirectory().equals(applicationLayersCacheConfiguration.getCacheDirectory())) {
                helpfulSuggestion = helpfulSuggestions.forCacheNeedsClean();
            }
            throw new BuildStepsExecutionException(helpfulSuggestion, ex);
        }
    }
}

