/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaEntrypointConstructor {
    public static final String DEFAULT_DEPENDENCIES_PATH_ON_IMAGE = "/app/libs/";
    public static final String DEFAULT_RESOURCES_PATH_ON_IMAGE = "/app/resources/";
    public static final String DEFAULT_CLASSES_PATH_ON_IMAGE = "/app/classes/";

    public static List<String> makeDefaultEntrypoint(List<String> jvmFlags, String mainClass) {
        return JavaEntrypointConstructor.makeEntrypoint(Arrays.asList("/app/libs/*", DEFAULT_RESOURCES_PATH_ON_IMAGE, DEFAULT_CLASSES_PATH_ON_IMAGE), jvmFlags, mainClass);
    }

    public static List<String> makeEntrypoint(List<String> classpathElements, List<String> jvmFlags, String mainClass) {
        String classpathString = String.join((CharSequence)":", classpathElements);
        ArrayList<String> entrypointBuilder = new ArrayList<String>(4 + jvmFlags.size());
        entrypointBuilder.add("java");
        entrypointBuilder.addAll(jvmFlags);
        entrypointBuilder.add("-cp");
        entrypointBuilder.add(classpathString);
        entrypointBuilder.add(mainClass);
        return entrypointBuilder;
    }

    private JavaEntrypointConstructor() {
    }
}

