/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.annotation.Nullable;

public class MainClassFinder {
    private final ImmutableList<Path> classesFiles;
    private final JibLogger buildLogger;

    public MainClassFinder(ImmutableList<Path> classesFiles, JibLogger buildLogger) {
        this.classesFiles = classesFiles;
        this.buildLogger = buildLogger;
    }

    public Result find() {
        try {
            ArrayList<String> mainClasses = new ArrayList<String>();
            HashSet<Path> roots = new HashSet<Path>();
            for (Path classPath : this.classesFiles) {
                roots.add(classPath.getParent());
            }
            for (Path root : roots) {
                mainClasses.addAll(this.findMainClasses(root));
            }
            if (mainClasses.size() == 1) {
                return Result.success((String)mainClasses.get(0));
            }
            if (mainClasses.size() == 0) {
                return Result.mainClassNotFound();
            }
            return Result.multipleMainClasses(mainClasses);
        }
        catch (IOException ex) {
            return Result.ioException(ex);
        }
    }

    private List<String> findMainClasses(Path rootDirectory) throws IOException {
        if (!Files.exists(rootDirectory, new LinkOption[0]) || !Files.isDirectory(rootDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>();
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        try {
            CtClass[] mainMethodParams = new CtClass[]{classPool.get("java.lang.String[]")};
            new DirectoryWalker(rootDirectory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".class")).walk(classFile -> {
                try (InputStream classFileInputStream2 = Files.newInputStream(classFile, new OpenOption[0]);){
                    CtClass fileClass = classPool.makeClass(classFileInputStream2);
                    CtMethod mainMethod = fileClass.getDeclaredMethod("main", mainMethodParams);
                    if (CtClass.voidType.equals(mainMethod.getReturnType()) && Modifier.isStatic(mainMethod.getModifiers()) && Modifier.isPublic(mainMethod.getModifiers())) {
                        classNames.add(fileClass.getName());
                    }
                }
                catch (NotFoundException classFileInputStream2) {
                }
                catch (IOException ex) {
                    this.buildLogger.warn("Could not read class file: " + classFile);
                }
            });
            return classNames;
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class Result {
        private final boolean isSuccess;
        private final List<String> foundMainClasses;
        @Nullable
        private final ErrorType errorType;
        @Nullable
        private final Throwable errorCause;

        private static Result success(String foundMainClass) {
            return new Result(true, Collections.singletonList(foundMainClass), null, null);
        }

        private static Result mainClassNotFound() {
            return new Result(false, Collections.emptyList(), ErrorType.MAIN_CLASS_NOT_FOUND, null);
        }

        private static Result multipleMainClasses(List<String> foundMainClasses) {
            return new Result(false, foundMainClasses, ErrorType.MULTIPLE_MAIN_CLASSES, null);
        }

        private static Result ioException(IOException ioException) {
            return new Result(false, Collections.emptyList(), ErrorType.IO_EXCEPTION, ioException);
        }

        private Result(boolean isSuccess, List<String> foundMainClasses, @Nullable ErrorType errorType, @Nullable Throwable errorCause) {
            this.isSuccess = isSuccess;
            this.foundMainClasses = foundMainClasses;
            this.errorType = errorType;
            this.errorCause = errorCause;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getFoundMainClass() {
            Preconditions.checkArgument((boolean)this.isSuccess);
            Preconditions.checkArgument((this.foundMainClasses.size() == 1 ? 1 : 0) != 0);
            return this.foundMainClasses.get(0);
        }

        public ErrorType getErrorType() {
            return (ErrorType)((Object)Preconditions.checkNotNull((Object)((Object)this.errorType)));
        }

        public Throwable getErrorCause() {
            return (Throwable)Preconditions.checkNotNull((Object)this.errorCause);
        }

        public List<String> getFoundMainClasses() {
            return this.foundMainClasses;
        }

        public static enum ErrorType {
            IO_EXCEPTION,
            MAIN_CLASS_NOT_FOUND,
            MULTIPLE_MAIN_CLASSES;

        }
    }
}

