/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.frontend.MainClassFinder;
import com.google.cloud.tools.jib.frontend.MainClassInferenceException;
import com.google.cloud.tools.jib.frontend.ProjectProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;

public class MainClassResolver {
    public static String resolveMainClass(@Nullable String mainClass, ProjectProperties projectProperties) throws MainClassInferenceException {
        if (mainClass == null) {
            mainClass = MainClassResolver.getMainClassFromJar(projectProperties);
        }
        if (mainClass == null) {
            mainClass = MainClassResolver.findMainClassInClassFiles(projectProperties);
        } else if (!MainClassResolver.isValidJavaClass(mainClass)) {
            try {
                mainClass = MainClassResolver.findMainClassInClassFiles(projectProperties);
            }
            catch (MainClassInferenceException mainClassInferenceException) {
                // empty catch block
            }
        }
        Preconditions.checkNotNull((Object)mainClass);
        if (!MainClassResolver.isValidJavaClass(mainClass)) {
            projectProperties.getLogger().warn("'mainClass' is not a valid Java class : " + mainClass);
        }
        return mainClass;
    }

    @VisibleForTesting
    static boolean isValidJavaClass(String className) {
        for (String part : Splitter.on((char)'.').split((CharSequence)className)) {
            if (SourceVersion.isIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getMainClassFromJar(ProjectProperties projectProperties) {
        projectProperties.getLogger().info("Searching for main class... Add a 'mainClass' configuration to '" + projectProperties.getPluginName() + "' to improve build speed.");
        return projectProperties.getMainClassFromJar();
    }

    private static String findMainClassInClassFiles(ProjectProperties projectProperties) throws MainClassInferenceException {
        projectProperties.getLogger().debug("Could not find a valid main class specified in " + projectProperties.getJarPluginName() + "; attempting to infer main class.");
        MainClassFinder.Result mainClassFinderResult = new MainClassFinder(projectProperties.getClassesLayerEntry().getSourceFiles(), projectProperties.getLogger()).find();
        if (mainClassFinderResult.isSuccess()) {
            return mainClassFinderResult.getFoundMainClass();
        }
        Verify.verify((mainClassFinderResult.getErrorType() != null ? 1 : 0) != 0);
        switch (mainClassFinderResult.getErrorType()) {
            case MAIN_CLASS_NOT_FOUND: {
                throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Main class was not found").forMainClassNotFound(projectProperties.getPluginName()));
            }
            case MULTIPLE_MAIN_CLASSES: {
                throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Multiple valid main classes were found: " + String.join((CharSequence)", ", mainClassFinderResult.getFoundMainClasses())).forMainClassNotFound(projectProperties.getPluginName()));
            }
            case IO_EXCEPTION: {
                throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Failed to get main class").forMainClassNotFound(projectProperties.getPluginName()), mainClassFinderResult.getErrorCause());
            }
        }
        throw new IllegalStateException("Cannot reach here");
    }

    private MainClassResolver() {
    }
}

