/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Image<T extends Layer> {
    @Nullable
    private final Instant created;
    private final ImageLayers<T> layers;
    @Nullable
    private final ImmutableMap<String, String> environment;
    @Nullable
    private final ImmutableList<String> entrypoint;
    @Nullable
    private final ImmutableList<String> javaArguments;
    @Nullable
    private final ImmutableList<Port> exposedPorts;

    public static <T extends Layer> Builder<T> builder() {
        return new Builder();
    }

    private Image(@Nullable Instant created, ImageLayers<T> layers, @Nullable ImmutableMap<String, String> environment, @Nullable ImmutableList<String> entrypoint, @Nullable ImmutableList<String> javaArguments, @Nullable ImmutableList<Port> exposedPorts) {
        this.created = created;
        this.layers = layers;
        this.environment = environment;
        this.entrypoint = entrypoint;
        this.javaArguments = javaArguments;
        this.exposedPorts = exposedPorts;
    }

    @Nullable
    public Instant getCreated() {
        return this.created;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    @Nullable
    public ImmutableList<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    public ImmutableList<T> getLayers() {
        return this.layers.getLayers();
    }

    public static class Builder<T extends Layer> {
        private final ImageLayers.Builder<T> imageLayersBuilder = ImageLayers.builder();
        private ImmutableMap.Builder<String, String> environmentBuilder = ImmutableMap.builder();
        @Nullable
        private Instant created;
        @Nullable
        private ImmutableList<String> entrypoint;
        @Nullable
        private ImmutableList<String> javaArguments;
        @Nullable
        private ImmutableList<Port> exposedPorts;

        public Builder<T> setCreated(Instant created) {
            this.created = created;
            return this;
        }

        public Builder<T> addEnvironment(@Nullable Map<String, String> environment) {
            if (environment != null) {
                this.environmentBuilder.putAll(environment);
            }
            return this;
        }

        public Builder<T> setEnvironmentVariable(String name, String value) {
            this.environmentBuilder.put((Object)name, (Object)value);
            return this;
        }

        public Builder<T> setEntrypoint(@Nullable List<String> entrypoint) {
            this.entrypoint = entrypoint == null ? null : ImmutableList.copyOf(entrypoint);
            return this;
        }

        public Builder<T> setJavaArguments(@Nullable List<String> javaArguments) {
            this.javaArguments = javaArguments == null ? null : ImmutableList.copyOf(javaArguments);
            return this;
        }

        public Builder<T> setExposedPorts(@Nullable ImmutableList<Port> exposedPorts) {
            this.exposedPorts = exposedPorts == null ? null : exposedPorts;
            return this;
        }

        public Builder<T> addLayer(T layer) throws LayerPropertyNotFoundException {
            this.imageLayersBuilder.add(layer);
            return this;
        }

        public Image<T> build() {
            return new Image(this.created, this.imageLayersBuilder.build(), this.environmentBuilder.build(), this.entrypoint, this.javaArguments, this.exposedPorts);
        }
    }
}

