/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;

public class ImageLayers<T extends Layer>
implements Iterable<T> {
    private final ImmutableList<T> layers;
    private final ImmutableSet<DescriptorDigest> layerDigests;

    public static <U extends Layer> Builder<U> builder() {
        return new Builder();
    }

    private ImageLayers(ImmutableList<T> layers, ImmutableSet<DescriptorDigest> layerDigests) {
        this.layers = layers;
        this.layerDigests = layerDigests;
    }

    public ImmutableList<T> getLayers() {
        return this.layers;
    }

    public int size() {
        return this.layers.size();
    }

    public boolean isEmpty() {
        return this.layers.isEmpty();
    }

    public T get(int index) {
        return (T)((Layer)this.layers.get(index));
    }

    @Nullable
    public T get(DescriptorDigest digest) throws LayerPropertyNotFoundException {
        if (!this.has(digest)) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getBlobDescriptor().getDigest().equals(digest)) continue;
            return (T)layer;
        }
        throw new IllegalStateException("Layer digest exists but layer not found");
    }

    public boolean has(DescriptorDigest digest) {
        return this.layerDigests.contains((Object)digest);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getLayers().iterator();
    }

    public static class Builder<T extends Layer> {
        private final LinkedHashSet<T> layers = new LinkedHashSet();
        private final ImmutableSet.Builder<DescriptorDigest> layerDigestsBuilder = ImmutableSet.builder();

        public Builder<T> add(T layer) throws LayerPropertyNotFoundException {
            this.layerDigestsBuilder.add((Object)layer.getBlobDescriptor().getDigest());
            this.layers.remove(layer);
            this.layers.add(layer);
            return this;
        }

        public <U extends T> Builder<T> addAll(ImageLayers<U> layers) throws LayerPropertyNotFoundException {
            for (Layer layer : layers) {
                this.add(layer);
            }
            return this;
        }

        public ImageLayers<T> build() {
            return new ImageLayers(ImmutableList.copyOf(this.layers), this.layerDigestsBuilder.build());
        }
    }
}

