/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.BuildStepsRunner;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.frontend.SystemPropertyValidator;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.ImageFormat;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.maven.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenJibLogger;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildImageMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "build";
    private static final String USER_AGENT_SUFFIX = "jib-maven-plugin";
    private static final HelpfulSuggestions HELPFUL_SUGGESTIONS = HelpfulSuggestionsProvider.get("Build image failed");

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        MavenJibLogger mavenJibLogger = new MavenJibLogger(this.getLog());
        this.handleDeprecatedParameters(mavenJibLogger);
        SystemPropertyValidator.checkHttpTimeoutProperty(MojoExecutionException::new);
        if (Arrays.stream(ImageFormat.values()).noneMatch(value -> value.name().equals(this.getFormat()))) {
            throw new MojoFailureException("<format> parameter is configured with value '" + this.getFormat() + "', but the only valid configuration options are '" + (Object)((Object)ImageFormat.Docker) + "' and '" + (Object)((Object)ImageFormat.OCI) + "'.");
        }
        ImageReference baseImage = BuildImageMojo.parseImageReference(this.getBaseImage(), "from");
        if (Strings.isNullOrEmpty((String)this.getTargetImage())) {
            throw new MojoFailureException(HelpfulSuggestionsProvider.get("Missing target image parameter").forToNotConfigured("<to><image>", "pom.xml", "mvn compile jib:build -Dimage=<your image name>"));
        }
        ImageReference targetImage = BuildImageMojo.parseImageReference(this.getTargetImage(), "to");
        if (Boolean.getBoolean("sendCredentialsOverHttp")) {
            mavenJibLogger.warn("Authentication over HTTP is enabled. It is strongly recommended that you do not enable this on a public network!");
        }
        MavenSettingsServerCredentials mavenSettingsServerCredentials = new MavenSettingsServerCredentials(((MavenSession)Preconditions.checkNotNull((Object)this.session)).getSettings(), this.settingsDecrypter, mavenJibLogger);
        Authorization fromAuthorization = this.getBaseImageAuth();
        RegistryCredentials knownBaseRegistryCredentials = fromAuthorization != null ? new RegistryCredentials("jib-maven-plugin <from><auth> configuration", fromAuthorization) : mavenSettingsServerCredentials.retrieve(baseImage.getRegistry());
        Authorization toAuthorization = this.getTargetImageAuth();
        RegistryCredentials knownTargetRegistryCredentials = toAuthorization != null ? new RegistryCredentials("jib-maven-plugin <to><auth> configuration", toAuthorization) : mavenSettingsServerCredentials.retrieve(targetImage.getRegistry());
        MavenProjectProperties mavenProjectProperties = MavenProjectProperties.getForProject(this.getProject(), mavenJibLogger, this.getExtraDirectory());
        String mainClass = mavenProjectProperties.getMainClass(this);
        ImageConfiguration baseImageConfiguration = ImageConfiguration.builder(baseImage).setCredentialHelper(this.getBaseImageCredentialHelperName()).setKnownRegistryCredentials(knownBaseRegistryCredentials).build();
        ImageConfiguration targetImageConfiguration = ImageConfiguration.builder(targetImage).setCredentialHelper(this.getTargetImageCredentialHelperName()).setKnownRegistryCredentials(knownTargetRegistryCredentials).build();
        ContainerConfiguration.Builder containerConfigurationBuilder = ContainerConfiguration.builder().setEntrypoint(JavaEntrypointConstructor.makeDefaultEntrypoint(this.getJvmFlags(), mainClass)).setProgramArguments(this.getArgs()).setEnvironment(this.getEnvironment()).setExposedPorts((List<Port>)ExposedPortsParser.parse(this.getExposedPorts()));
        if (this.getUseCurrentTimestamp()) {
            mavenJibLogger.warn("Setting image creation time to current time; your image may not be reproducible.");
            containerConfigurationBuilder.setCreationTime(Instant.now());
        }
        BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.builder(mavenJibLogger).setBaseImageConfiguration(baseImageConfiguration).setTargetImageConfiguration(targetImageConfiguration).setContainerConfiguration(containerConfigurationBuilder.build()).setTargetFormat(ImageFormat.valueOf(this.getFormat()).getManifestTemplateClass()).setAllowInsecureRegistries(this.getAllowInsecureRegistries()).setLayerConfigurations((List<LayerConfiguration>)mavenProjectProperties.getLayerConfigurations());
        CacheConfiguration applicationLayersCacheConfiguration = CacheConfiguration.forPath(mavenProjectProperties.getCacheDirectory());
        buildConfigurationBuilder.setApplicationLayersCacheConfiguration(applicationLayersCacheConfiguration);
        if (this.getUseOnlyProjectCache()) {
            buildConfigurationBuilder.setBaseImageLayersCacheConfiguration(applicationLayersCacheConfiguration);
        }
        BuildConfiguration buildConfiguration = buildConfigurationBuilder.build();
        MavenJibLogger.disableHttpLogging();
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        try {
            BuildStepsRunner.forBuildImage(buildConfiguration).build(HELPFUL_SUGGESTIONS);
            this.getLog().info((CharSequence)"");
        }
        catch (CacheDirectoryCreationException | BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }
}

