/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.SettingsDecrypter;

abstract class JibPluginConfiguration
extends AbstractMojo {
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private FromConfiguration from = new FromConfiguration();
    @Parameter(property="image")
    private ToConfiguration to = new ToConfiguration();
    @Parameter
    private ContainerParameters container = new ContainerParameters();
    @Deprecated
    @Parameter
    private List<String> jvmFlags = Collections.emptyList();
    @Nullable
    @Parameter
    private Map<String, String> environment;
    @Deprecated
    @Nullable
    @Parameter
    private String mainClass;
    @Deprecated
    @Parameter
    private List<String> args = Collections.emptyList();
    @Deprecated
    @Nullable
    @Parameter
    private String format;
    @Parameter(defaultValue="false", required=true)
    private boolean useOnlyProjectCache;
    @Parameter(defaultValue="false", required=true)
    private boolean allowInsecureRegistries;
    @Nullable
    @Parameter(defaultValue="${project.basedir}/src/main/jib", required=true)
    private String extraDirectory;
    @Nullable
    @Component
    protected SettingsDecrypter settingsDecrypter;

    JibPluginConfiguration() {
    }

    static ImageReference parseImageReference(String image, String type) {
        try {
            return ImageReference.parse(image);
        }
        catch (InvalidImageReferenceException ex) {
            throw new IllegalStateException("Parameter '" + type + "' is invalid", ex);
        }
    }

    @Nullable
    @VisibleForTesting
    static Authorization getImageAuth(String usernameProperty, String passwordProperty, AuthConfiguration auth) {
        String commandlineUsername = System.getProperty(usernameProperty);
        String commandlinePassword = System.getProperty(passwordProperty);
        if (commandlineUsername != null && commandlinePassword != null) {
            return Authorizations.withBasicCredentials(commandlineUsername, commandlinePassword);
        }
        return auth.getAuthorization();
    }

    void handleDeprecatedParameters(JibLogger logger) {
        StringBuilder deprecatedParams = new StringBuilder();
        if (!this.jvmFlags.isEmpty()) {
            deprecatedParams.append("  <jvmFlags> -> <container><jvmFlags>\n");
            if (this.container.jvmFlags.isEmpty()) {
                this.container.jvmFlags = this.jvmFlags;
            }
        }
        if (!Strings.isNullOrEmpty((String)this.mainClass)) {
            deprecatedParams.append("  <mainClass> -> <container><mainClass>\n");
            if (Strings.isNullOrEmpty((String)this.container.mainClass)) {
                this.container.mainClass = this.mainClass;
            }
        }
        if (!this.args.isEmpty()) {
            deprecatedParams.append("  <args> -> <container><args>\n");
            if (this.container.args.isEmpty()) {
                this.container.args = this.args;
            }
        }
        if (!Strings.isNullOrEmpty((String)this.format)) {
            deprecatedParams.append("  <format> -> <container><format>\n");
            this.container.format = this.format;
        }
        if (deprecatedParams.length() > 0) {
            logger.warn("There are deprecated parameters used in the build configuration. Please make the following changes to your pom.xml to avoid issues in the future:\n" + deprecatedParams);
        }
    }

    MavenProject getProject() {
        return (MavenProject)Preconditions.checkNotNull((Object)this.project);
    }

    String getBaseImage() {
        return (String)Preconditions.checkNotNull((Object)((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).image);
    }

    @Nullable
    String getBaseImageCredentialHelperName() {
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).credHelper;
    }

    @Nullable
    Authorization getBaseImageAuth() {
        return JibPluginConfiguration.getImageAuth("jib.from.auth.username", "jib.from.auth.password", this.from.auth);
    }

    @Nullable
    String getTargetImage() {
        return this.to.image;
    }

    @Nullable
    String getTargetImageCredentialHelperName() {
        return ((ToConfiguration)Preconditions.checkNotNull((Object)this.to)).credHelper;
    }

    @Nullable
    Authorization getTargetImageAuth() {
        return JibPluginConfiguration.getImageAuth("jib.to.auth.username", "jib.to.auth.password", this.to.auth);
    }

    boolean getUseCurrentTimestamp() {
        return this.container.useCurrentTimestamp;
    }

    List<String> getJvmFlags() {
        return this.container.jvmFlags;
    }

    @Nullable
    Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    String getMainClass() {
        return this.container.mainClass;
    }

    List<String> getArgs() {
        return this.container.args;
    }

    List<String> getExposedPorts() {
        return this.container.ports;
    }

    String getFormat() {
        return (String)Preconditions.checkNotNull((Object)this.container.format);
    }

    boolean getUseOnlyProjectCache() {
        return this.useOnlyProjectCache;
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    Path getExtraDirectory() {
        return Paths.get((String)Preconditions.checkNotNull((Object)this.extraDirectory), new String[0]);
    }

    @VisibleForTesting
    void setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
    }

    @VisibleForTesting
    void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @VisibleForTesting
    void setArgs(List<String> args) {
        this.args = args;
    }

    @VisibleForTesting
    void setFormat(String format) {
        this.format = format;
    }

    @VisibleForTesting
    void setProject(MavenProject project) {
        this.project = project;
    }

    @VisibleForTesting
    void setTargetImage(@Nullable String targetImage) {
        this.to.image = targetImage;
    }

    @VisibleForTesting
    void setExtraDirectory(String extraDirectory) {
        this.extraDirectory = extraDirectory;
    }

    public static class ContainerParameters {
        @Parameter
        private boolean useCurrentTimestamp = false;
        @Parameter
        private List<String> jvmFlags = Collections.emptyList();
        @Nullable
        @Parameter
        private String mainClass;
        @Parameter
        private List<String> args = Collections.emptyList();
        @Nullable
        @Parameter(required=true)
        private String format = "Docker";
        @Parameter
        private List<String> ports = Collections.emptyList();
    }

    public static class ToConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private AuthConfiguration auth = new AuthConfiguration();

        public void set(String image) {
            this.image = image;
        }
    }

    public static class FromConfiguration {
        @Nullable
        @Parameter(required=true)
        private String image = "gcr.io/distroless/java";
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private AuthConfiguration auth = new AuthConfiguration();
    }

    public static class AuthConfiguration {
        @Nullable
        @Parameter
        private String username;
        @Nullable
        @Parameter
        private String password;

        @VisibleForTesting
        void setUsername(String username) {
            this.username = username;
        }

        @VisibleForTesting
        void setPassword(String password) {
            this.password = password;
        }

        @Nullable
        private Authorization getAuthorization() {
            if (this.username == null || this.password == null) {
                return null;
            }
            return Authorizations.withBasicCredentials(this.username, this.password);
        }
    }
}

