/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class MavenLayerConfigurations {
    private static final String DEPENDENCIES_LAYER_LABEL = "dependencies";
    private static final String SNAPSHOT_DEPENDENCIES_LAYER_LABEL = "snapshot dependencies";
    private static final String RESOURCES_LAYER_LABEL = "resources";
    private static final String CLASSES_LAYER_LABEL = "classes";
    private static final String EXTRA_FILES_LAYER_LABEL = "extra files";
    private final LayerConfiguration dependenciesLayerConfiguration;
    private final LayerConfiguration snapshotDependenciesLayerConfiguration;
    private final LayerConfiguration resourcesLayerConfiguration;
    private final LayerConfiguration classesLayerConfiguration;
    private final LayerConfiguration extraFilesLayerConfiguration;

    static MavenLayerConfigurations getForProject(MavenProject project, Path extraDirectory) throws IOException {
        Path classesSourceDirectory = Paths.get(project.getBuild().getSourceDirectory(), new String[0]);
        Path classesOutputDirectory = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        ArrayList<Path> dependenciesFiles = new ArrayList<Path>();
        ArrayList<Path> snapshotDependenciesFiles = new ArrayList<Path>();
        ArrayList<Path> resourcesFiles = new ArrayList<Path>();
        ArrayList<Path> classesFiles = new ArrayList<Path>();
        ArrayList<Path> extraFiles = new ArrayList();
        for (Artifact artifact : project.getArtifacts()) {
            if (artifact.isSnapshot()) {
                snapshotDependenciesFiles.add(artifact.getFile().toPath());
                continue;
            }
            dependenciesFiles.add(artifact.getFile().toPath());
        }
        try (Stream<Path> classFileStream = Files.list(classesOutputDirectory);){
            classFileStream.forEach(classFile -> {
                if (Files.isDirectory(classFile, new LinkOption[0]) && Files.exists(classesSourceDirectory.resolve(classesOutputDirectory.relativize((Path)classFile)), new LinkOption[0])) {
                    classesFiles.add((Path)classFile);
                    return;
                }
                if (FileSystems.getDefault().getPathMatcher("glob:**.class").matches((Path)classFile)) {
                    classesFiles.add((Path)classFile);
                    return;
                }
                resourcesFiles.add((Path)classFile);
            });
        }
        if (Files.exists(extraDirectory, new LinkOption[0])) {
            try {
                var10_11 = null;
                try (Stream<Path> extraFilesLayerDirectoryFiles = Files.list(extraDirectory);){
                    extraFiles = extraFilesLayerDirectoryFiles.collect(Collectors.toList());
                }
                catch (Throwable throwable) {
                    var10_11 = throwable;
                    throw throwable;
                }
            }
            catch (IOException ex) {
                throw new IOException("Failed to list directory for extra files: " + extraDirectory, ex);
            }
        }
        Collections.sort(dependenciesFiles);
        Collections.sort(snapshotDependenciesFiles);
        Collections.sort(resourcesFiles);
        Collections.sort(classesFiles);
        Collections.sort(extraFiles);
        return new MavenLayerConfigurations(LayerConfiguration.builder().addEntry(dependenciesFiles, "/app/libs/").setLabel(DEPENDENCIES_LAYER_LABEL).build(), LayerConfiguration.builder().addEntry(snapshotDependenciesFiles, "/app/libs/").setLabel(SNAPSHOT_DEPENDENCIES_LAYER_LABEL).build(), LayerConfiguration.builder().addEntry(resourcesFiles, "/app/resources/").setLabel(RESOURCES_LAYER_LABEL).build(), LayerConfiguration.builder().addEntry(classesFiles, "/app/classes/").setLabel(CLASSES_LAYER_LABEL).build(), LayerConfiguration.builder().addEntry(extraFiles, "/").setLabel(EXTRA_FILES_LAYER_LABEL).build());
    }

    private MavenLayerConfigurations(LayerConfiguration dependenciesLayerConfiguration, LayerConfiguration snapshotDependenciesLayerConfiguration, LayerConfiguration resourcesLayerConfiguration, LayerConfiguration classesLayerConfiguration, LayerConfiguration extraFilesLayerConfiguration) {
        this.dependenciesLayerConfiguration = dependenciesLayerConfiguration;
        this.snapshotDependenciesLayerConfiguration = snapshotDependenciesLayerConfiguration;
        this.resourcesLayerConfiguration = resourcesLayerConfiguration;
        this.classesLayerConfiguration = classesLayerConfiguration;
        this.extraFilesLayerConfiguration = extraFilesLayerConfiguration;
    }

    ImmutableList<LayerConfiguration> getLayerConfigurations() {
        return ImmutableList.of((Object)this.dependenciesLayerConfiguration, (Object)this.snapshotDependenciesLayerConfiguration, (Object)this.resourcesLayerConfiguration, (Object)this.classesLayerConfiguration, (Object)this.extraFilesLayerConfiguration);
    }

    LayerEntry getDependenciesLayerEntry() {
        return (LayerEntry)this.dependenciesLayerConfiguration.getLayerEntries().get(0);
    }

    LayerEntry getSnapshotDependenciesLayerEntry() {
        return (LayerEntry)this.snapshotDependenciesLayerConfiguration.getLayerEntries().get(0);
    }

    LayerEntry getResourcesLayerEntry() {
        return (LayerEntry)this.resourcesLayerConfiguration.getLayerEntries().get(0);
    }

    LayerEntry getClassesLayerEntry() {
        return (LayerEntry)this.classesLayerConfiguration.getLayerEntries().get(0);
    }

    LayerEntry getExtraFilesLayerEntry() {
        return (LayerEntry)this.extraFilesLayerConfiguration.getLayerEntries().get(0);
    }
}

