/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.frontend.MainClassInferenceException;
import com.google.cloud.tools.jib.frontend.MainClassResolver;
import com.google.cloud.tools.jib.frontend.ProjectProperties;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.maven.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenJibLogger;
import com.google.cloud.tools.jib.maven.MavenLayerConfigurations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class MavenProjectProperties
implements ProjectProperties {
    private static final String PLUGIN_NAME = "jib-maven-plugin";
    private static final String JAR_PLUGIN_NAME = "'maven-jar-plugin'";
    private final MavenProject project;
    private final MavenJibLogger mavenJibLogger;
    private final MavenLayerConfigurations mavenLayerConfigurations;

    static MavenProjectProperties getForProject(MavenProject project, MavenJibLogger mavenJibLogger, Path extraDirectory) throws MojoExecutionException {
        try {
            return new MavenProjectProperties(project, mavenJibLogger, MavenLayerConfigurations.getForProject(project, extraDirectory));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Obtaining project build output files failed; make sure you have compiled your project before trying to build the image. (Did you accidentally run \"mvn clean jib:build\" instead of \"mvn clean compile jib:build\"?)", (Exception)ex);
        }
    }

    @VisibleForTesting
    MavenProjectProperties(MavenProject project, MavenJibLogger mavenJibLogger, MavenLayerConfigurations mavenLayerConfigurations) {
        this.project = project;
        this.mavenJibLogger = mavenJibLogger;
        this.mavenLayerConfigurations = mavenLayerConfigurations;
    }

    @Override
    public ImmutableList<LayerConfiguration> getLayerConfigurations() {
        return this.mavenLayerConfigurations.getLayerConfigurations();
    }

    @Override
    public LayerEntry getDependenciesLayerEntry() {
        return this.mavenLayerConfigurations.getDependenciesLayerEntry();
    }

    @Override
    public LayerEntry getSnapshotDependenciesLayerEntry() {
        return this.mavenLayerConfigurations.getSnapshotDependenciesLayerEntry();
    }

    @Override
    public LayerEntry getResourcesLayerEntry() {
        return this.mavenLayerConfigurations.getResourcesLayerEntry();
    }

    @Override
    public LayerEntry getClassesLayerEntry() {
        return this.mavenLayerConfigurations.getClassesLayerEntry();
    }

    @Override
    public LayerEntry getExtraFilesLayerEntry() {
        return this.mavenLayerConfigurations.getExtraFilesLayerEntry();
    }

    @Override
    public HelpfulSuggestions getMainClassHelpfulSuggestions(String prefix) {
        return HelpfulSuggestionsProvider.get(prefix);
    }

    @Override
    public JibLogger getLogger() {
        return this.mavenJibLogger;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        Plugin mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (mavenJarPlugin != null) {
            Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
            if (jarConfiguration == null) {
                return null;
            }
            Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
            if (archiveObject == null) {
                return null;
            }
            Xpp3Dom manifestObject = archiveObject.getChild("manifest");
            if (manifestObject == null) {
                return null;
            }
            Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
            if (mainClassObject == null) {
                return null;
            }
            return mainClassObject.getValue();
        }
        return null;
    }

    @Override
    public Path getCacheDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), "jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    String getMainClass(JibPluginConfiguration jibPluginConfiguration) throws MojoExecutionException {
        try {
            return MainClassResolver.resolveMainClass(jibPluginConfiguration.getMainClass(), this);
        }
        catch (MainClassInferenceException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    ImageReference getGeneratedTargetDockerTag(@Nullable String targetImage, MavenJibLogger mavenJibLogger) {
        if (Strings.isNullOrEmpty((String)targetImage)) {
            mavenJibLogger.lifecycle("Tagging image with generated image reference " + this.project.getName() + ":" + this.project.getVersion() + ". If you'd like to specify a different tag, you can set the <to><image> parameter in your pom.xml, or use the -Dimage=<MY IMAGE> commandline flag.");
            return ImageReference.of(null, this.project.getName(), this.project.getVersion());
        }
        return JibPluginConfiguration.parseImageReference(targetImage, "to");
    }
}

