/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryNoResponseException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.HttpHostConnectException;

class RegistryEndpointCaller<T> {
    @VisibleForTesting
    static final int STATUS_CODE_PERMANENT_REDIRECT = 308;
    private static final String DEFAULT_PROTOCOL = "https";
    private final JibLogger logger;
    private final URL initialRequestUrl;
    private final String userAgent;
    private final RegistryEndpointProvider<T> registryEndpointProvider;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowInsecureRegistries;
    private final Function<URL, Connection> connectionFactory;
    @Nullable
    private Function<URL, Connection> insecureConnectionFactory;

    private static boolean isHttpsProtocol(URL url) {
        return DEFAULT_PROTOCOL.equals(url.getProtocol());
    }

    RegistryEndpointCaller(JibLogger logger, String userAgent, String apiRouteBase, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowInsecureRegistries) throws MalformedURLException {
        this(logger, userAgent, apiRouteBase, registryEndpointProvider, authorization, registryEndpointRequestProperties, allowInsecureRegistries, Connection.getConnectionFactory(), null);
    }

    @VisibleForTesting
    RegistryEndpointCaller(JibLogger logger, String userAgent, String apiRouteBase, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowInsecureRegistries, Function<URL, Connection> connectionFactory, @Nullable Function<URL, Connection> insecureConnectionFactory) throws MalformedURLException {
        this.logger = logger;
        this.initialRequestUrl = registryEndpointProvider.getApiRoute("https://" + apiRouteBase);
        this.userAgent = userAgent;
        this.registryEndpointProvider = registryEndpointProvider;
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowInsecureRegistries = allowInsecureRegistries;
        this.connectionFactory = connectionFactory;
        this.insecureConnectionFactory = insecureConnectionFactory;
    }

    @Nullable
    T call() throws IOException, RegistryException {
        return this.callWithAllowInsecureRegistryHandling(this.initialRequestUrl);
    }

    @Nullable
    private T callWithAllowInsecureRegistryHandling(URL url) throws IOException, RegistryException {
        if (!RegistryEndpointCaller.isHttpsProtocol(url) && !this.allowInsecureRegistries) {
            throw new InsecureRegistryException(url);
        }
        try {
            return this.call(url, this.connectionFactory);
        }
        catch (SSLPeerUnverifiedException ex) {
            return this.handleUnverifiableServerException(url);
        }
    }

    @Nullable
    private T handleUnverifiableServerException(URL url) throws IOException, RegistryException {
        if (!this.allowInsecureRegistries) {
            throw new InsecureRegistryException(url);
        }
        try {
            return this.call(url, this.getInsecureConnectionFactory());
        }
        catch (SSLPeerUnverifiedException | HttpHostConnectException ex) {
            GenericUrl httpUrl = new GenericUrl(url);
            httpUrl.setScheme("http");
            this.logger.warn("Failed to connect to " + url + " over HTTPS. Attempting again with HTTP: " + httpUrl);
            return this.call(httpUrl.toURL(), this.connectionFactory);
        }
    }

    private Function<URL, Connection> getInsecureConnectionFactory() throws RegistryException {
        try {
            if (this.insecureConnectionFactory == null) {
                this.insecureConnectionFactory = Connection.getInsecureConnectionFactory();
            }
            return this.insecureConnectionFactory;
        }
        catch (GeneralSecurityException ex) {
            throw new RegistryException("cannot turn off TLS peer verification", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private T call(URL url, Function<URL, Connection> connectionFactory) throws IOException, RegistryException {
        boolean sendCredentials = RegistryEndpointCaller.isHttpsProtocol(url) || Boolean.getBoolean("sendCredentialsOverHttp");
        try (Connection connection = connectionFactory.apply(url);){
            Request.Builder requestBuilder = Request.builder().setUserAgent(this.userAgent).setHttpTimeout(Integer.getInteger("jib.httpTimeout")).setAccept(this.registryEndpointProvider.getAccept()).setBody(this.registryEndpointProvider.getContent());
            if (sendCredentials) {
                requestBuilder.setAuthorization(this.authorization);
            }
            Response response = connection.send(this.registryEndpointProvider.getHttpMethod(), requestBuilder.build());
            T t = this.registryEndpointProvider.handleResponse(response);
            return t;
        }
        catch (HttpResponseException ex) {
            try {
                return this.registryEndpointProvider.handleHttpResponseException(ex);
            }
            catch (HttpResponseException httpResponseException) {
                if (httpResponseException.getStatusCode() == 400 || httpResponseException.getStatusCode() == 404 || httpResponseException.getStatusCode() == 405) {
                    ErrorResponseTemplate errorResponse = JsonTemplateMapper.readJson(httpResponseException.getContent(), ErrorResponseTemplate.class);
                    RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.registryEndpointProvider.getActionDescription(), httpResponseException);
                    Iterator<ErrorEntryTemplate> iterator = errorResponse.getErrors().iterator();
                    while (iterator.hasNext()) {
                        ErrorEntryTemplate errorEntry = iterator.next();
                        registryErrorExceptionBuilder.addReason(errorEntry);
                    }
                    throw registryErrorExceptionBuilder.build();
                }
                if (httpResponseException.getStatusCode() == 403) {
                    throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException);
                }
                if (httpResponseException.getStatusCode() == 401) {
                    if (!sendCredentials) throw new RegistryCredentialsNotSentException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName());
                    throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException);
                }
                if (httpResponseException.getStatusCode() != 307 && httpResponseException.getStatusCode() != 301) {
                    if (httpResponseException.getStatusCode() != 308) throw httpResponseException;
                }
                URL redirectLocation = new URL(url, httpResponseException.getHeaders().getLocation());
                return this.callWithAllowInsecureRegistryHandling(redirectLocation);
            }
        }
        catch (NoHttpResponseException ex) {
            throw new RegistryNoResponseException(ex);
        }
    }
}

