/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class DockerCredentialHelper {
    private final String serverUrl;
    private final String credentialHelperSuffix;

    DockerCredentialHelper(String serverUrl, String credentialHelperSuffix) {
        this.serverUrl = serverUrl;
        this.credentialHelperSuffix = credentialHelperSuffix;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Authorization retrieve() throws IOException, NonexistentServerUrlDockerCredentialHelperException, NonexistentDockerCredentialHelperException {
        try {
            String credentialHelper = "docker-credential-" + this.credentialHelperSuffix;
            String[] credentialHelperCommand = new String[]{credentialHelper, "get"};
            Process process = new ProcessBuilder(credentialHelperCommand).start();
            try (OutputStream processStdin = process.getOutputStream();){
                processStdin.write(this.serverUrl.getBytes(StandardCharsets.UTF_8));
            }
            var5_6 = null;
            try (InputStreamReader processStdoutReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
                String output = CharStreams.toString((Readable)processStdoutReader);
                if (output.contains("credentials not found in native keychain")) {
                    throw new NonexistentServerUrlDockerCredentialHelperException(credentialHelper, this.serverUrl, output);
                }
                if (output.isEmpty()) {
                    InputStreamReader processStderrReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        try {
                            String errorOutput = CharStreams.toString((Readable)processStderrReader);
                            throw new NonexistentServerUrlDockerCredentialHelperException(credentialHelper, this.serverUrl, errorOutput);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        DockerCredentialHelper.$closeResource(throwable, processStderrReader);
                        throw throwable3;
                    }
                }
                try {
                    DockerCredentialsTemplate dockerCredentials = JsonTemplateMapper.readJson(output, DockerCredentialsTemplate.class);
                    if (Strings.isNullOrEmpty((String)dockerCredentials.Username) || Strings.isNullOrEmpty((String)dockerCredentials.Secret)) {
                        throw new NonexistentServerUrlDockerCredentialHelperException(credentialHelper, this.serverUrl, output);
                    }
                    Authorization authorization = Authorizations.withBasicCredentials(dockerCredentials.Username, dockerCredentials.Secret);
                    return authorization;
                }
                catch (JsonProcessingException ex) {
                    try {
                        throw new NonexistentServerUrlDockerCredentialHelperException(credentialHelper, this.serverUrl, output);
                    }
                    catch (Throwable throwable) {
                        var5_6 = throwable;
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException ex) {
            if (ex.getMessage() == null) {
                throw ex;
            }
            if (ex.getMessage().contains("No such file or directory") || ex.getMessage().contains("cannot find the file")) {
                throw new NonexistentDockerCredentialHelperException(this.credentialHelperSuffix, ex);
            }
            throw ex;
        }
    }

    @VisibleForTesting
    String getServerUrl() {
        return this.serverUrl;
    }

    @VisibleForTesting
    String getCredentialHelperSuffix() {
        return this.credentialHelperSuffix;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class DockerCredentialsTemplate
    implements JsonTemplate {
        @Nullable
        private String Username;
        @Nullable
        private String Secret;

        private DockerCredentialsTemplate() {
        }
    }
}

