/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayerStep
implements AsyncStep<CachedLayer>,
Callable<CachedLayer> {
    private static final String DESCRIPTION = "Building application layers";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final String layerType;
    private final LayerConfiguration layerConfiguration;
    private final ListenableFuture<CachedLayer> listenableFuture;

    static ImmutableList<BuildAndCacheApplicationLayerStep> makeList(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        int layerCount = buildConfiguration.getLayerConfigurations().size();
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("setting up to build application layers", layerCount);){
            UnmodifiableIterator unmodifiableIterator;
            TimerEventDispatcher ignored = new TimerEventDispatcher(buildConfiguration.getEventDispatcher(), DESCRIPTION);
            Throwable throwable2 = null;
            try {
                ImmutableList.Builder buildAndCacheApplicationLayerSteps = ImmutableList.builderWithExpectedSize((int)layerCount);
                for (LayerConfiguration layerConfiguration : buildConfiguration.getLayerConfigurations()) {
                    if (layerConfiguration.getLayerEntries().isEmpty()) continue;
                    buildAndCacheApplicationLayerSteps.add((Object)new BuildAndCacheApplicationLayerStep(listeningExecutorService, buildConfiguration, progressEventDispatcher.newChildProducer(), layerConfiguration.getName(), layerConfiguration));
                }
                unmodifiableIterator = buildAndCacheApplicationLayerSteps.build();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored);
            return unmodifiableIterator;
        }
    }

    private BuildAndCacheApplicationLayerStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, String layerType, LayerConfiguration layerConfiguration) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.layerType = layerType;
        this.layerConfiguration = layerConfiguration;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<CachedLayer> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public CachedLayer call() throws IOException, CacheCorruptedException {
        String description = "Building " + this.layerType + " layer";
        this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.progress(description + "..."));
        Throwable throwable = null;
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("building " + this.layerType + " layer", 1L);){
            CachedLayer cachedLayer;
            Cache cache;
            Throwable throwable2;
            TimerEventDispatcher ignored2;
            block13: {
                ignored2 = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), description);
                throwable2 = null;
                cache = this.buildConfiguration.getApplicationLayersCache();
                Optional<CachedLayer> optionalCachedLayer = cache.retrieve(this.layerConfiguration.getLayerEntries());
                if (!optionalCachedLayer.isPresent()) break block13;
                CachedLayer cachedLayer2 = optionalCachedLayer.get();
                BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
                return cachedLayer2;
            }
            try {
                Blob layerBlob = new ReproducibleLayerBuilder(this.layerConfiguration.getLayerEntries()).build();
                CachedLayer cachedLayer3 = cache.writeUncompressedLayer(layerBlob, this.layerConfiguration.getLayerEntries());
                this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.debug(description + " built " + cachedLayer3.getDigest()));
                cachedLayer = cachedLayer3;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
            return cachedLayer;
        }
    }

    String getLayerType() {
        return this.layerType;
    }
}

