/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.Objects;

public class BuildResult {
    private final DescriptorDigest imageDigest;
    private final DescriptorDigest imageId;

    static BuildResult fromImage(Image<Layer> image, Class<? extends BuildableManifestTemplate> targetFormat) throws IOException {
        ImageToJsonTranslator imageToJsonTranslator = new ImageToJsonTranslator(image);
        BlobDescriptor containerConfigurationBlobDescriptor = imageToJsonTranslator.getContainerConfigurationBlob().writeTo(ByteStreams.nullOutputStream());
        BuildableManifestTemplate manifestTemplate = imageToJsonTranslator.getManifestTemplate(targetFormat, containerConfigurationBlobDescriptor);
        DescriptorDigest imageDigest = JsonTemplateMapper.toBlob(manifestTemplate).writeTo(ByteStreams.nullOutputStream()).getDigest();
        DescriptorDigest imageId = containerConfigurationBlobDescriptor.getDigest();
        return new BuildResult(imageDigest, imageId);
    }

    BuildResult(DescriptorDigest imageDigest, DescriptorDigest imageId) {
        this.imageDigest = imageDigest;
        this.imageId = imageId;
    }

    public DescriptorDigest getImageDigest() {
        return this.imageDigest;
    }

    public DescriptorDigest getImageId() {
        return this.imageId;
    }

    public int hashCode() {
        return Objects.hash(this.imageDigest, this.imageId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildResult)) {
            return false;
        }
        BuildResult otherBuildResult = (BuildResult)other;
        return this.imageDigest.equals(otherBuildResult.imageDigest) && this.imageId.equals(otherBuildResult.imageId);
    }
}

