/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class FinalizingStep
implements AsyncStep<Void>,
Callable<Void> {
    private final BuildConfiguration buildConfiguration;
    private final List<AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>>> futureDependencyLists;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Void> listenableFuture;

    FinalizingStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, List<AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>>> wrappedDependencyLists, List<? extends AsyncStep<?>> dependencyList) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.futureDependencyLists = wrappedDependencyLists;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addSteps(wrappedDependencyLists).addSteps(dependencyList).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<Void> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public Void call() throws ExecutionException {
        AsyncDependencies asyncDependencies = AsyncDependencies.using(this.listeningExecutorService);
        for (AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>> asyncStep : this.futureDependencyLists) {
            asyncDependencies.addSteps((List)NonBlockingSteps.get(asyncStep));
        }
        ListenableFuture<Void> ignored = asyncDependencies.whenAllSucceed(() -> {
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.progress("Finalizing..."));
            return null;
        });
        return null;
    }
}

