/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ContainerConfiguration {
    public static final Instant DEFAULT_CREATION_TIME = Instant.EPOCH;
    private final Instant creationTime;
    @Nullable
    private final ImmutableList<String> entrypoint;
    @Nullable
    private final ImmutableList<String> programArguments;
    @Nullable
    private final ImmutableMap<String, String> environmentMap;
    @Nullable
    private final ImmutableSet<Port> exposedPorts;
    @Nullable
    private final ImmutableSet<AbsoluteUnixPath> volumes;
    @Nullable
    private final ImmutableMap<String, String> labels;
    @Nullable
    private final String user;
    @Nullable
    private final AbsoluteUnixPath workingDirectory;

    public static Builder builder() {
        return new Builder();
    }

    private ContainerConfiguration(Instant creationTime, @Nullable ImmutableList<String> entrypoint, @Nullable ImmutableList<String> programArguments, @Nullable ImmutableMap<String, String> environmentMap, @Nullable ImmutableSet<Port> exposedPorts, @Nullable ImmutableSet<AbsoluteUnixPath> volumes, @Nullable ImmutableMap<String, String> labels, @Nullable String user, @Nullable AbsoluteUnixPath workingDirectory) {
        this.creationTime = creationTime;
        this.entrypoint = entrypoint;
        this.programArguments = programArguments;
        this.environmentMap = environmentMap;
        this.exposedPorts = exposedPorts;
        this.volumes = volumes;
        this.labels = labels;
        this.user = user;
        this.workingDirectory = workingDirectory;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public ImmutableList<String> getProgramArguments() {
        return this.programArguments;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvironmentMap() {
        return this.environmentMap;
    }

    @Nullable
    public ImmutableSet<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    @Nullable
    public ImmutableSet<AbsoluteUnixPath> getVolumes() {
        return this.volumes;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    @Nullable
    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    @Nullable
    public AbsoluteUnixPath getWorkingDirectory() {
        return this.workingDirectory;
    }

    @VisibleForTesting
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContainerConfiguration)) {
            return false;
        }
        ContainerConfiguration otherContainerConfiguration = (ContainerConfiguration)other;
        return this.creationTime.equals(otherContainerConfiguration.creationTime) && Objects.equals(this.entrypoint, otherContainerConfiguration.entrypoint) && Objects.equals(this.programArguments, otherContainerConfiguration.programArguments) && Objects.equals(this.environmentMap, otherContainerConfiguration.environmentMap) && Objects.equals(this.exposedPorts, otherContainerConfiguration.exposedPorts) && Objects.equals(this.labels, otherContainerConfiguration.labels) && Objects.equals(this.user, otherContainerConfiguration.user) && Objects.equals(this.workingDirectory, otherContainerConfiguration.workingDirectory);
    }

    @VisibleForTesting
    public int hashCode() {
        return Objects.hash(this.creationTime, this.entrypoint, this.programArguments, this.environmentMap, this.exposedPorts, this.labels, this.user);
    }

    public static class Builder {
        private Instant creationTime = DEFAULT_CREATION_TIME;
        @Nullable
        private ImmutableList<String> entrypoint;
        @Nullable
        private ImmutableList<String> programArguments;
        @Nullable
        private Map<String, String> environmentMap;
        @Nullable
        private Set<Port> exposedPorts;
        @Nullable
        private Set<AbsoluteUnixPath> volumes;
        @Nullable
        private Map<String, String> labels;
        @Nullable
        private String user;
        @Nullable
        private AbsoluteUnixPath workingDirectory;

        public Builder setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setProgramArguments(@Nullable List<String> programArguments) {
            if (programArguments == null) {
                this.programArguments = null;
            } else {
                Preconditions.checkArgument((!programArguments.contains(null) ? 1 : 0) != 0);
                this.programArguments = ImmutableList.copyOf(programArguments);
            }
            return this;
        }

        public Builder setEnvironment(@Nullable Map<String, String> environmentMap) {
            if (environmentMap == null) {
                this.environmentMap = null;
            } else {
                Preconditions.checkArgument((!Iterables.any(environmentMap.keySet(), Objects::isNull) ? 1 : 0) != 0);
                Preconditions.checkArgument((!Iterables.any(environmentMap.values(), Objects::isNull) ? 1 : 0) != 0);
                this.environmentMap = new HashMap<String, String>(environmentMap);
            }
            return this;
        }

        public void addEnvironment(String name, String value) {
            if (this.environmentMap == null) {
                this.environmentMap = new HashMap<String, String>();
            }
            this.environmentMap.put(name, value);
        }

        public Builder setExposedPorts(@Nullable Set<Port> exposedPorts) {
            if (exposedPorts == null) {
                this.exposedPorts = null;
            } else {
                Preconditions.checkArgument((!exposedPorts.contains(null) ? 1 : 0) != 0);
                this.exposedPorts = new HashSet<Port>(exposedPorts);
            }
            return this;
        }

        public void addExposedPort(Port port) {
            if (this.exposedPorts == null) {
                this.exposedPorts = new HashSet<Port>();
            }
            this.exposedPorts.add(port);
        }

        public Builder setVolumes(@Nullable Set<AbsoluteUnixPath> volumes) {
            if (volumes == null) {
                this.volumes = null;
            } else {
                Preconditions.checkArgument((!volumes.contains(null) ? 1 : 0) != 0);
                this.volumes = new HashSet<AbsoluteUnixPath>(volumes);
            }
            return this;
        }

        public void addVolume(AbsoluteUnixPath volume) {
            if (this.volumes == null) {
                this.volumes = new HashSet<AbsoluteUnixPath>();
            }
            this.volumes.add(volume);
        }

        public Builder setLabels(@Nullable Map<String, String> labels) {
            if (labels == null) {
                this.labels = null;
            } else {
                Preconditions.checkArgument((!Iterables.any(labels.keySet(), Objects::isNull) ? 1 : 0) != 0);
                Preconditions.checkArgument((!Iterables.any(labels.values(), Objects::isNull) ? 1 : 0) != 0);
                this.labels = new HashMap<String, String>(labels);
            }
            return this;
        }

        public void addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new HashMap<String, String>();
            }
            this.labels.put(key, value);
        }

        public Builder setEntrypoint(@Nullable List<String> entrypoint) {
            if (entrypoint == null) {
                this.entrypoint = null;
            } else {
                Preconditions.checkArgument((!entrypoint.contains(null) ? 1 : 0) != 0);
                this.entrypoint = ImmutableList.copyOf(entrypoint);
            }
            return this;
        }

        public Builder setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public Builder setWorkingDirectory(@Nullable AbsoluteUnixPath workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public ContainerConfiguration build() {
            return new ContainerConfiguration(this.creationTime, this.entrypoint, this.programArguments, this.environmentMap == null ? null : ImmutableMap.copyOf(this.environmentMap), this.exposedPorts == null ? null : ImmutableSet.copyOf(this.exposedPorts), this.volumes == null ? null : ImmutableSet.copyOf(this.volumes), this.labels == null ? null : ImmutableMap.copyOf(this.labels), this.user, this.workingDirectory);
        }

        private Builder() {
        }
    }
}

