/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event;

import com.google.cloud.tools.jib.event.Handler;
import com.google.cloud.tools.jib.event.JibEvent;
import com.google.cloud.tools.jib.event.JibEventType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;

public class EventHandlers {
    private final Multimap<Class<? extends JibEvent>, Handler<? extends JibEvent>> handlers = ArrayListMultimap.create();

    public <E extends JibEvent> EventHandlers add(JibEventType<E> eventType, Consumer<E> eventConsumer) {
        Class<E> eventClass = eventType.getEventClass();
        this.handlers.put(eventClass, new Handler<E>(eventClass, eventConsumer));
        return this;
    }

    public EventHandlers add(Consumer<JibEvent> eventConsumer) {
        return this.add(JibEventType.ALL, eventConsumer);
    }

    ImmutableMultimap<Class<? extends JibEvent>, Handler<? extends JibEvent>> getHandlers() {
        return ImmutableMultimap.copyOf(this.handlers);
    }
}

