/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event.progress;

import com.google.cloud.tools.jib.event.progress.Allocation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class AllocationCompletionTracker {
    private final ConcurrentHashMap<Allocation, InsertionOrderUnits> completionMap = new ConcurrentHashMap();

    AllocationCompletionTracker() {
    }

    boolean updateProgress(Allocation allocation, long units) {
        if (units == 0L) {
            boolean alreadyPresent = this.completionMap.containsKey(allocation);
            this.completionMap.computeIfAbsent(allocation, x$0 -> new InsertionOrderUnits((Allocation)x$0));
            return !alreadyPresent;
        }
        this.completionMap.compute(allocation, (ignored, insertionOrderUnits) -> {
            if (insertionOrderUnits == null) {
                insertionOrderUnits = new InsertionOrderUnits(allocation);
            }
            this.updateInsertionOrderUnits((InsertionOrderUnits)insertionOrderUnits, units);
            return insertionOrderUnits;
        });
        return true;
    }

    ImmutableList<Allocation> getUnfinishedAllocations() {
        PriorityQueue<InsertionOrderUnits> unfinishedInsertionOrderUnits = new PriorityQueue<InsertionOrderUnits>();
        for (InsertionOrderUnits insertionOrderUnits : this.completionMap.values()) {
            if (insertionOrderUnits.units.get() >= insertionOrderUnits.allocation.getAllocationUnits()) continue;
            unfinishedInsertionOrderUnits.add(insertionOrderUnits);
        }
        ImmutableList.Builder unfinishedAllocations = ImmutableList.builderWithExpectedSize((int)unfinishedInsertionOrderUnits.size());
        while (!unfinishedInsertionOrderUnits.isEmpty()) {
            unfinishedAllocations.add((Object)((InsertionOrderUnits)unfinishedInsertionOrderUnits.remove()).allocation);
        }
        return unfinishedAllocations.build();
    }

    private void updateInsertionOrderUnits(InsertionOrderUnits insertionOrderUnits, long units) {
        Allocation allocation = insertionOrderUnits.allocation;
        long newUnits = insertionOrderUnits.units.addAndGet(units);
        if (newUnits > allocation.getAllocationUnits()) {
            throw new IllegalStateException("Progress exceeds max for '" + allocation.getDescription() + "': " + newUnits + " > " + allocation.getAllocationUnits());
        }
        if (newUnits == allocation.getAllocationUnits()) {
            allocation.getParent().ifPresent(parentAllocation -> this.updateInsertionOrderUnits((InsertionOrderUnits)Preconditions.checkNotNull((Object)this.completionMap.get(parentAllocation)), 1L));
        }
    }

    private static class InsertionOrderUnits
    implements Comparable<InsertionOrderUnits> {
        private static final AtomicInteger currentIndex = new AtomicInteger();
        private final int index = currentIndex.getAndIncrement();
        private final AtomicLong units = new AtomicLong();
        private final Allocation allocation;

        private InsertionOrderUnits(Allocation allocation) {
            this.allocation = allocation;
        }

        @Override
        public int compareTo(InsertionOrderUnits otherInsertionOrderUnits) {
            return this.index - otherInsertionOrderUnits.index;
        }
    }
}

