/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.HttpContent;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.http.BlobProgressListener;
import com.google.cloud.tools.jib.http.ListenableCountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class BlobHttpContent
implements HttpContent {
    private final Blob blob;
    private final String contentType;
    @Nullable
    private final BlobProgressListener blobProgressListener;

    public BlobHttpContent(Blob blob, String contentType, @Nullable BlobProgressListener blobProgressListener) {
        this.blob = blob;
        this.contentType = contentType;
        this.blobProgressListener = blobProgressListener;
    }

    public long getLength() {
        return -1L;
    }

    public String getType() {
        return this.contentType;
    }

    public boolean retrySupported() {
        return false;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream = this.blobProgressListener == null ? outputStream : new ListenableCountingOutputStream(outputStream, this.blobProgressListener::handleByteCount, this.blobProgressListener.getDelayBetweenCallbacks());
        this.blob.writeTo(outputStream);
        outputStream.flush();
    }
}

