/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ListenableCountingOutputStream
extends OutputStream {
    private final OutputStream underlyingOutputStream;
    private final Consumer<Long> byteCountConsumer;
    private final Duration delayBetweenCallbacks;
    private final Supplier<Instant> instantSupplier;
    private long byteCount = 0L;
    private Instant previousCallback;

    public ListenableCountingOutputStream(OutputStream underlyingOutputStream, Consumer<Long> byteCountConsumer, Duration delayBetweenCallbacks) {
        this(underlyingOutputStream, byteCountConsumer, delayBetweenCallbacks, Instant::now);
    }

    @VisibleForTesting
    ListenableCountingOutputStream(OutputStream underlyingOutputStream, Consumer<Long> byteCountConsumer, Duration delayBetweenCallbacks, Supplier<Instant> instantSupplier) {
        this.underlyingOutputStream = underlyingOutputStream;
        this.byteCountConsumer = byteCountConsumer;
        this.delayBetweenCallbacks = delayBetweenCallbacks;
        this.instantSupplier = instantSupplier;
        this.previousCallback = instantSupplier.get();
    }

    @Override
    public void write(int singleByte) throws IOException {
        this.underlyingOutputStream.write(singleByte);
        this.countBytesWritten(1);
    }

    @Override
    public void write(byte[] byteArray) throws IOException {
        this.underlyingOutputStream.write(byteArray);
        this.countBytesWritten(byteArray.length);
    }

    @Override
    public void write(byte[] byteArray, int offset, int length) throws IOException {
        this.underlyingOutputStream.write(byteArray, offset, length);
        this.countBytesWritten(length);
    }

    @Override
    public void flush() throws IOException {
        this.underlyingOutputStream.flush();
        this.callByteCountConsumer(this.instantSupplier.get());
    }

    @Override
    public void close() throws IOException {
        this.underlyingOutputStream.close();
        this.callByteCountConsumer(this.instantSupplier.get());
    }

    private void countBytesWritten(int byteCount) {
        this.byteCount += (long)byteCount;
        Instant now = this.instantSupplier.get();
        if (this.previousCallback.plus(this.delayBetweenCallbacks).isBefore(now)) {
            this.callByteCountConsumer(now);
        }
    }

    private void callByteCountConsumer(Instant now) {
        if (this.byteCount == 0L) {
            return;
        }
        this.byteCountConsumer.accept(this.byteCount);
        this.byteCount = 0L;
        this.previousCallback = now;
    }
}

