/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.DefaultEventDispatcher;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenRawConfiguration;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.maven.ProxyProvider;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsRunner;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.InferredAuthRetrievalException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dockerBuild", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildDockerMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "dockerBuild";
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build to Docker daemon failed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return;
        }
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        if (!DockerClient.isDefaultDockerInstalled()) {
            throw new MojoExecutionException(HelpfulSuggestions.forDockerNotInstalled(HELPFUL_SUGGESTIONS_PREFIX));
        }
        try {
            AbsoluteUnixPath appRoot = MojoCommon.getAppRootChecked(this);
            MavenProjectProperties projectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getLog(), MojoCommon.getExtraDirectoryPath(this), MojoCommon.convertPermissionsList(this.getExtraDirectoryPermissions()), appRoot);
            DefaultEventDispatcher eventDispatcher = new DefaultEventDispatcher(projectProperties.getEventHandlers());
            MavenHelpfulSuggestionsBuilder mavenHelpfulSuggestionsBuilder = new MavenHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this);
            PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfigurationForDockerDaemonImage(new MavenRawConfiguration(this), new MavenSettingsServerCredentials(this.getSession().getSettings(), this.getSettingsDecrypter(), eventDispatcher), projectProperties, null, null, mavenHelpfulSuggestionsBuilder.build());
            ProxyProvider.init(this.getSession().getSettings());
            ImageReference targetImageReference = pluginConfigurationProcessor.getTargetImageReference();
            HelpfulSuggestions helpfulSuggestions = mavenHelpfulSuggestionsBuilder.setBaseImageReference(pluginConfigurationProcessor.getBaseImageReference()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(targetImageReference).build();
            Path buildOutput = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
            try {
                BuildStepsRunner.forBuildToDockerDaemon(targetImageReference, this.getTargetImageAdditionalTags()).writeImageDigest(buildOutput.resolve("jib-image.digest")).writeImageId(buildOutput.resolve("jib-image.id")).build(pluginConfigurationProcessor.getJibContainerBuilder(), pluginConfigurationProcessor.getContainerizer(), eventDispatcher, (List<LayerConfiguration>)projectProperties.getJavaLayerConfigurations().getLayerConfigurations(), helpfulSuggestions);
            }
            finally {
                projectProperties.waitForLoggingThread();
                this.getLog().info((CharSequence)"");
            }
        }
        catch (InvalidAppRootException ex) {
            throw new MojoExecutionException("<container><appRoot> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new MojoExecutionException("<container><workingDirectory> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new MojoExecutionException("<container><volumes> is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Exception)ex);
        }
        catch (CacheDirectoryCreationException | InvalidImageReferenceException | InferredAuthRetrievalException | MainClassInferenceException | IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        catch (BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }
}

