/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public abstract class JibPluginConfiguration
extends AbstractMojo {
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private FromConfiguration from = new FromConfiguration();
    @Parameter
    private ToConfiguration to = new ToConfiguration();
    @Parameter
    private ContainerParameters container = new ContainerParameters();
    @Parameter
    private ExtraDirectoryParameters extraDirectory = new ExtraDirectoryParameters();
    @Parameter(defaultValue="false", required=true, property="jib.allowInsecureRegistries")
    private boolean allowInsecureRegistries;
    @Parameter(defaultValue="false", property="jib.skip")
    private boolean skip;
    @Nullable
    @Component
    protected SettingsDecrypter settingsDecrypter;

    MavenSession getSession() {
        return (MavenSession)Preconditions.checkNotNull((Object)this.session);
    }

    MavenProject getProject() {
        return (MavenProject)Preconditions.checkNotNull((Object)this.project);
    }

    @Nullable
    String getBaseImage() {
        if (System.getProperty("jib.from.image") != null) {
            return System.getProperty("jib.from.image");
        }
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).image;
    }

    @Nullable
    String getBaseImageCredentialHelperName() {
        if (System.getProperty("jib.from.credHelper") != null) {
            return System.getProperty("jib.from.credHelper");
        }
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).credHelper;
    }

    AuthConfiguration getBaseImageAuth() {
        return this.from.auth;
    }

    @Nullable
    String getTargetImage() {
        if (System.getProperty("image") != null) {
            return System.getProperty("image");
        }
        if (System.getProperty("jib.to.image") != null) {
            return System.getProperty("jib.to.image");
        }
        return this.to.image;
    }

    Set<String> getTargetImageAdditionalTags() {
        if (System.getProperty("jib.to.tags") != null) {
            return ImmutableSet.copyOf(ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.to.tags")));
        }
        return new HashSet<String>(this.to.tags);
    }

    @Nullable
    String getTargetImageCredentialHelperName() {
        if (System.getProperty("jib.to.credHelper") != null) {
            return System.getProperty("jib.to.credHelper");
        }
        return ((ToConfiguration)Preconditions.checkNotNull((Object)this.to)).credHelper;
    }

    AuthConfiguration getTargetImageAuth() {
        return this.to.auth;
    }

    boolean getUseCurrentTimestamp() {
        if (System.getProperty("jib.container.useCurrentTimestamp") != null) {
            return Boolean.getBoolean("jib.container.useCurrentTimestamp");
        }
        return this.container.useCurrentTimestamp;
    }

    @Nullable
    List<String> getEntrypoint() {
        if (System.getProperty("jib.container.entrypoint") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.entrypoint"));
        }
        return this.container.entrypoint;
    }

    List<String> getJvmFlags() {
        if (System.getProperty("jib.container.jvmFlags") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.jvmFlags"));
        }
        return this.container.jvmFlags;
    }

    Map<String, String> getEnvironment() {
        if (System.getProperty("jib.container.environment") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.container.environment"));
        }
        return this.container.environment;
    }

    @Nullable
    String getMainClass() {
        if (System.getProperty("jib.container.mainClass") != null) {
            return System.getProperty("jib.container.mainClass");
        }
        return this.container.mainClass;
    }

    @Nullable
    String getUser() {
        if (System.getProperty("jib.container.user") != null) {
            return System.getProperty("jib.container.user");
        }
        return this.container.user;
    }

    @Nullable
    String getWorkingDirectory() {
        if (System.getProperty("jib.container.workingDirectory") != null) {
            return System.getProperty("jib.container.workingDirectory");
        }
        return this.container.workingDirectory;
    }

    @Nullable
    List<String> getArgs() {
        if (System.getProperty("jib.container.args") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.args"));
        }
        return this.container.args;
    }

    List<String> getExposedPorts() {
        if (System.getProperty("jib.container.ports") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.ports"));
        }
        return this.container.ports;
    }

    List<String> getVolumes() {
        if (System.getProperty("jib.container.volumes") != null) {
            return ConfigurationPropertyValidator.parseListProperty(System.getProperty("jib.container.volumes"));
        }
        return this.container.volumes;
    }

    Map<String, String> getLabels() {
        if (System.getProperty("jib.container.labels") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.container.labels"));
        }
        return this.container.labels;
    }

    String getAppRoot() {
        if (System.getProperty("jib.container.appRoot") != null) {
            return System.getProperty("jib.container.appRoot");
        }
        return this.container.appRoot;
    }

    String getFormat() {
        if (System.getProperty("jib.container.format") != null) {
            return System.getProperty("jib.container.format");
        }
        return (String)Preconditions.checkNotNull((Object)this.container.format);
    }

    Optional<Path> getExtraDirectoryPath() {
        if (System.getProperty("jib.extraDirectory.path") != null) {
            return Optional.of(Paths.get(System.getProperty("jib.extraDirectory.path"), new String[0]));
        }
        return this.extraDirectory.path == null ? Optional.empty() : Optional.of(this.extraDirectory.path.toPath());
    }

    List<PermissionConfiguration> getExtraDirectoryPermissions() {
        if (System.getProperty("jib.extraDirectory.permissions") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.extraDirectory.permissions")).entrySet().stream().map(entry -> new PermissionConfiguration((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        }
        return this.extraDirectory.permissions;
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    boolean isSkipped() {
        return this.skip;
    }

    SettingsDecrypter getSettingsDecrypter() {
        return (SettingsDecrypter)Preconditions.checkNotNull((Object)this.settingsDecrypter);
    }

    @VisibleForTesting
    void setProject(MavenProject project) {
        this.project = project;
    }

    public static class ExtraDirectoryParameters {
        @Nullable
        @Parameter
        private File path;
        @Parameter
        private List<PermissionConfiguration> permissions = Collections.emptyList();

        public void set(File path) {
            this.path = path;
        }

        @Nullable
        public File getPath() {
            return this.path;
        }
    }

    public static class ContainerParameters {
        @Parameter
        private boolean useCurrentTimestamp = false;
        @Nullable
        @Parameter
        private List<String> entrypoint;
        @Parameter
        private List<String> jvmFlags = Collections.emptyList();
        @Parameter
        private Map<String, String> environment = Collections.emptyMap();
        @Nullable
        @Parameter
        private String mainClass;
        @Nullable
        @Parameter
        private List<String> args;
        @Nullable
        @Parameter(required=true)
        private String format = "Docker";
        @Parameter
        private List<String> ports = Collections.emptyList();
        @Parameter
        private List<String> volumes = Collections.emptyList();
        @Parameter
        private Map<String, String> labels = Collections.emptyMap();
        @Parameter
        private String appRoot = "";
        @Nullable
        @Parameter
        private String user;
        @Nullable
        @Parameter
        private String workingDirectory;
    }

    public static class ToConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Parameter
        private List<String> tags = Collections.emptyList();
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private ToAuthConfiguration auth = new ToAuthConfiguration();

        public void set(String image) {
            this.image = image;
        }
    }

    public static class FromConfiguration {
        @Nullable
        @Parameter(required=true)
        private String image;
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private FromAuthConfiguration auth = new FromAuthConfiguration();
    }

    public static class PermissionConfiguration {
        @Nullable
        @Parameter
        private String file;
        @Nullable
        @Parameter
        private String mode;

        public PermissionConfiguration() {
        }

        @VisibleForTesting
        PermissionConfiguration(String file, String mode) {
            this.file = file;
            this.mode = mode;
        }

        Optional<String> getFile() {
            return Optional.ofNullable(this.file);
        }

        Optional<String> getMode() {
            return Optional.ofNullable(this.mode);
        }
    }

    public static class ToAuthConfiguration
    extends AuthConfiguration {
        public ToAuthConfiguration() {
            super("to");
        }
    }

    public static class FromAuthConfiguration
    extends AuthConfiguration {
        public FromAuthConfiguration() {
            super("from");
        }
    }

    private static class AuthConfiguration
    implements AuthProperty {
        @Nullable
        @Parameter
        private String username;
        @Nullable
        @Parameter
        private String password;
        private final String source;

        private AuthConfiguration(String source) {
            this.source = source;
        }

        @Override
        @Nullable
        public String getUsername() {
            return this.username;
        }

        @Override
        @Nullable
        public String getPassword() {
            return this.password;
        }

        @Override
        public String getAuthDescriptor() {
            return "<" + this.source + "><auth>";
        }

        @Override
        public String getUsernameDescriptor() {
            return this.getAuthDescriptor() + "<username>";
        }

        @Override
        public String getPasswordDescriptor() {
            return this.getAuthDescriptor() + "<password>";
        }
    }
}

