/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.JavaLayerConfigurationsHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class MavenLayerConfigurations {
    static JavaLayerConfigurations getForProject(MavenProject project, Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions, AbsoluteUnixPath appRoot) throws IOException {
        if (MojoCommon.isWarProject(project)) {
            return MavenLayerConfigurations.getForWarProject(project, extraDirectory, extraDirectoryPermissions, appRoot);
        }
        return MavenLayerConfigurations.getForNonWarProject(project, extraDirectory, extraDirectoryPermissions, appRoot);
    }

    private static JavaLayerConfigurations getForNonWarProject(MavenProject project, Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions, AbsoluteUnixPath appRoot) throws IOException {
        AbsoluteUnixPath dependenciesExtractionPath = appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE);
        AbsoluteUnixPath resourcesExtractionPath = appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE);
        AbsoluteUnixPath classesExtractionPath = appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE);
        JavaLayerConfigurations.Builder layerBuilder = JavaLayerConfigurations.builder();
        List duplicates = project.getArtifacts().stream().map(Artifact::getFile).map(File::getName).collect(Collectors.groupingBy(filename -> filename, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        for (Artifact artifact : project.getArtifacts()) {
            Path artifactPath = artifact.getFile().toPath();
            JavaLayerConfigurations.LayerType layerType = artifact.isSnapshot() ? JavaLayerConfigurations.LayerType.SNAPSHOT_DEPENDENCIES : JavaLayerConfigurations.LayerType.DEPENDENCIES;
            String filename2 = artifactPath.getFileName().toString();
            layerBuilder.addFile(layerType, artifactPath, dependenciesExtractionPath.resolve(duplicates.contains(filename2) ? filename2.replaceFirst("\\.jar$", "-" + Files.size(artifactPath)) + ".jar" : filename2));
        }
        Path classesOutputDirectory = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        Predicate<Path> isClassFile = path -> path.getFileName().toString().endsWith(".class");
        layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.CLASSES, classesOutputDirectory, isClassFile, classesExtractionPath);
        layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.RESOURCES, classesOutputDirectory, isClassFile.negate(), resourcesExtractionPath);
        if (Files.exists(extraDirectory, new LinkOption[0])) {
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.EXTRA_FILES, extraDirectory, path -> true, AbsoluteUnixPath.get("/"), extraDirectoryPermissions);
        }
        return layerBuilder.build();
    }

    private static JavaLayerConfigurations getForWarProject(MavenProject project, Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions, AbsoluteUnixPath appRoot) throws IOException {
        Path explodedWarPath = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(project.getBuild().getFinalName());
        return JavaLayerConfigurationsHelper.fromExplodedWar(explodedWarPath, appRoot, extraDirectory, extraDirectoryPermissions);
    }

    private MavenLayerConfigurations() {
    }
}

