/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.event.JibEventType;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.event.progress.ProgressEventHandler;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import com.google.cloud.tools.jib.maven.MavenLayerConfigurations;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.TimerEventHandler;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLoggerBuilder;
import com.google.cloud.tools.jib.plugins.common.logging.ProgressDisplayGenerator;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.Os;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectProperties
implements ProjectProperties {
    public static final String PLUGIN_NAME = "jib-maven-plugin";
    public static final String PLUGIN_KEY = "com.google.cloud.tools:jib-maven-plugin";
    private static final String TOOL_NAME = "jib-maven-plugin";
    private static final String JAR_PLUGIN_NAME = "'maven-jar-plugin'";
    private final MavenProject project;
    private final SingleThreadedExecutor singleThreadedExecutor = new SingleThreadedExecutor();
    private final EventHandlers eventHandlers;
    private final JavaLayerConfigurations javaLayerConfigurations;

    static MavenProjectProperties getForProject(MavenProject project, Log log, Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> permissions, AbsoluteUnixPath appRoot) throws MojoExecutionException {
        try {
            return new MavenProjectProperties(project, log, MavenLayerConfigurations.getForProject(project, extraDirectory, permissions, appRoot));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Obtaining project build output files failed; make sure you have compiled your project before trying to build the image. (Did you accidentally run \"mvn clean jib:build\" instead of \"mvn clean compile jib:build\"?)", (Exception)ex);
        }
    }

    private static EventHandlers makeEventHandlers(Log log, SingleThreadedExecutor singleThreadedExecutor) {
        ConsoleLoggerBuilder logEventHandlerBuilder = (MavenProjectProperties.isProgressFooterEnabled() ? ConsoleLoggerBuilder.rich(singleThreadedExecutor) : ConsoleLoggerBuilder.plain(singleThreadedExecutor).progress(arg_0 -> ((Log)log).info(arg_0))).lifecycle(arg_0 -> ((Log)log).info(arg_0));
        if (log.isDebugEnabled()) {
            logEventHandlerBuilder.debug(arg_0 -> ((Log)log).debug(arg_0)).info(arg_0 -> ((Log)log).debug(arg_0));
        }
        if (log.isWarnEnabled()) {
            logEventHandlerBuilder.warn(arg_0 -> ((Log)log).warn(arg_0));
        }
        if (log.isErrorEnabled()) {
            logEventHandlerBuilder.error(arg_0 -> ((Log)log).error(arg_0));
        }
        ConsoleLogger consoleLogger = logEventHandlerBuilder.build();
        return new EventHandlers().add(JibEventType.LOGGING, logEvent -> consoleLogger.log(logEvent.getLevel(), logEvent.getMessage())).add(JibEventType.TIMING, new TimerEventHandler(message -> consoleLogger.log(LogEvent.Level.DEBUG, (String)message))).add(JibEventType.PROGRESS, new ProgressEventHandler(update -> consoleLogger.setFooter(ProgressDisplayGenerator.generateProgressDisplay(update.getProgress(), update.getUnfinishedAllocations()))));
    }

    private static boolean isProgressFooterEnabled() {
        if ("plain".equals(System.getProperty("jib.console"))) {
            return false;
        }
        if (Os.isFamily((String)"windows")) {
            return true;
        }
        return System.console() != null && !"dumb".equals(System.getenv("TERM"));
    }

    @VisibleForTesting
    MavenProjectProperties(MavenProject project, Log log, JavaLayerConfigurations javaLayerConfigurations) {
        this.project = project;
        this.javaLayerConfigurations = javaLayerConfigurations;
        this.eventHandlers = MavenProjectProperties.makeEventHandlers(log, this.singleThreadedExecutor);
    }

    @Override
    public JavaLayerConfigurations getJavaLayerConfigurations() {
        return this.javaLayerConfigurations;
    }

    @Override
    public void waitForLoggingThread() {
        this.singleThreadedExecutor.shutDownAndAwaitTermination();
    }

    @Override
    public EventHandlers getEventHandlers() {
        return this.eventHandlers;
    }

    @Override
    public String getToolName() {
        return "jib-maven-plugin";
    }

    @Override
    public String getPluginName() {
        return "jib-maven-plugin";
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        Plugin mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (mavenJarPlugin != null) {
            Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
            if (jarConfiguration == null) {
                return null;
            }
            Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
            if (archiveObject == null) {
                return null;
            }
            Xpp3Dom manifestObject = archiveObject.getChild("manifest");
            if (manifestObject == null) {
                return null;
            }
            Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
            if (mainClassObject == null) {
                return null;
            }
            return mainClassObject.getValue();
        }
        return null;
    }

    @Override
    public Path getDefaultCacheDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), "jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    @Override
    public boolean isWarProject() {
        return MojoCommon.isWarProject(this.project);
    }

    @Override
    public String getName() {
        return this.project.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.project.getVersion();
    }
}

