/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

class MojoCommon {
    static boolean isWarProject(MavenProject project) {
        String packaging = project.getPackaging();
        return "war".equals(packaging) || "gwt-app".equals(packaging);
    }

    static AbsoluteUnixPath getAppRootChecked(JibPluginConfiguration jibPluginConfiguration) throws InvalidAppRootException {
        String appRoot = jibPluginConfiguration.getAppRoot();
        if (appRoot.isEmpty()) {
            boolean isWarProject = MojoCommon.isWarProject(jibPluginConfiguration.getProject());
            appRoot = isWarProject ? "/jetty/webapps/ROOT" : "/app";
        }
        try {
            return AbsoluteUnixPath.get(appRoot);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidAppRootException(appRoot, appRoot, ex);
        }
    }

    static Path getExtraDirectoryPath(JibPluginConfiguration jibPluginConfiguration) {
        return jibPluginConfiguration.getExtraDirectoryPath().orElse(((MavenProject)Preconditions.checkNotNull((Object)jibPluginConfiguration.getProject())).getBasedir().toPath().resolve("src").resolve("main").resolve("jib"));
    }

    @VisibleForTesting
    static Map<AbsoluteUnixPath, FilePermissions> convertPermissionsList(List<JibPluginConfiguration.PermissionConfiguration> permissionList) {
        HashMap<AbsoluteUnixPath, FilePermissions> permissionsMap = new HashMap<AbsoluteUnixPath, FilePermissions>();
        for (JibPluginConfiguration.PermissionConfiguration permission : permissionList) {
            if (!permission.getFile().isPresent() || !permission.getMode().isPresent()) {
                throw new IllegalArgumentException("Incomplete <permission> configuration; requires <file> and <mode> fields to be set");
            }
            AbsoluteUnixPath key = AbsoluteUnixPath.get(permission.getFile().get());
            FilePermissions value = FilePermissions.fromOctalString(permission.getMode().get());
            permissionsMap.put(key, value);
        }
        return permissionsMap;
    }

    private MojoCommon() {
    }
}

