/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

public class ProxyProvider {
    private static final List<String> PROXY_PROPERTIES = Arrays.asList("proxyHost,proxyPort,proxyUser,proxyPassword".split(","));

    public static void init(Settings settings) {
        settings.getProxies().stream().filter(proxy -> proxy.isActive()).collect(Collectors.toList()).forEach(proxy -> ProxyProvider.setProxyProperties(proxy));
    }

    private static void setProxyProperties(Proxy proxy) {
        String protocol = proxy.getProtocol();
        if (protocol != null && !ProxyProvider.proxyPropertiesSet(protocol)) {
            ProxyProvider.setProxyProperty(protocol + ".proxyHost", proxy.getHost());
            ProxyProvider.setProxyProperty(protocol + ".proxyPort", String.valueOf(proxy.getPort()));
            ProxyProvider.setProxyProperty(protocol + ".proxyUser", proxy.getUsername());
            ProxyProvider.setProxyProperty(protocol + ".proxyPassword", proxy.getPassword());
            ProxyProvider.setProxyProperty("http.nonProxyHosts", proxy.getNonProxyHosts());
        }
    }

    private static void setProxyProperty(String property, String value) {
        if (property != null && value != null) {
            System.setProperty(property, value);
        }
    }

    private static boolean proxyPropertiesSet(String protocol) {
        return PROXY_PROPERTIES.stream().anyMatch(p -> System.getProperty(protocol + "." + p) != null);
    }
}

