/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.ErrorResponseUtil;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.DigestException;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

class ManifestPusher
implements RegistryEndpointProvider<DescriptorDigest> {
    private static final String RESPONSE_DIGEST_HEADER = "Docker-Content-Digest";
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final BuildableManifestTemplate manifestTemplate;
    private final String imageTag;
    private final EventDispatcher eventDispatcher;

    private static String makeUnexpectedImageDigestWarning(DescriptorDigest expectedDigest, List<String> receivedDigests) {
        if (receivedDigests.isEmpty()) {
            return "Expected image digest " + expectedDigest + ", but received none";
        }
        StringJoiner message = new StringJoiner(", ", "Expected image digest " + expectedDigest + ", but received: ", "");
        for (String receivedDigest : receivedDigests) {
            message.add(receivedDigest);
        }
        return message.toString();
    }

    ManifestPusher(RegistryEndpointRequestProperties registryEndpointRequestProperties, BuildableManifestTemplate manifestTemplate, String imageTag, EventDispatcher eventDispatcher) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.manifestTemplate = manifestTemplate;
        this.imageTag = imageTag;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public BlobHttpContent getContent() {
        return new BlobHttpContent(JsonTemplateMapper.toBlob(this.manifestTemplate), this.manifestTemplate.getManifestMediaType(), null);
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public DescriptorDigest handleHttpResponseException(HttpResponseException httpResponseException) throws HttpResponseException, RegistryErrorException {
        if (httpResponseException.getStatusCode() != 400 && httpResponseException.getStatusCode() != 415) {
            throw httpResponseException;
        }
        ErrorCodes errorCode = ErrorResponseUtil.getErrorCode(httpResponseException);
        if (errorCode == ErrorCodes.MANIFEST_INVALID || errorCode == ErrorCodes.TAG_INVALID) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription(), httpResponseException).addReason("Registry may not support Image Manifest Version 2, Schema 2").build();
        }
        throw httpResponseException;
    }

    @Override
    public DescriptorDigest handleResponse(Response response) throws IOException {
        DescriptorDigest expectedDigest = JsonTemplateMapper.toBlob(this.manifestTemplate).writeTo(ByteStreams.nullOutputStream()).getDigest();
        List<String> receivedDigests = response.getHeader(RESPONSE_DIGEST_HEADER);
        if (receivedDigests.size() == 1) {
            try {
                DescriptorDigest receivedDigest = DescriptorDigest.fromDigest(receivedDigests.get(0));
                if (expectedDigest.equals(receivedDigest)) {
                    return expectedDigest;
                }
            }
            catch (DigestException digestException) {
                // empty catch block
            }
        }
        this.eventDispatcher.dispatch(LogEvent.warn(ManifestPusher.makeUnexpectedImageDigestWarning(expectedDigest, receivedDigests)));
        return expectedDigest;
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointRequestProperties.getImageName() + "/manifests/" + this.imageTag);
    }

    @Override
    public String getHttpMethod() {
        return "PUT";
    }

    @Override
    public String getActionDescription() {
        return "push image manifest for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + ":" + this.imageTag;
    }
}

