/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.TargetImage;
import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.filesystem.UserCacheHome;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class Containerizer {
    public static final Path DEFAULT_BASE_CACHE_DIRECTORY = UserCacheHome.getCacheHome().resolve("google-cloud-tools-java").resolve("jib");
    private static final String DEFAULT_TOOL_NAME = "jib-core";
    private final TargetImage targetImage;
    private final Set<String> additionalTags = new HashSet<String>();
    @Nullable
    private ExecutorService executorService;
    private Path baseImageLayersCacheDirectory = DEFAULT_BASE_CACHE_DIRECTORY;
    @Nullable
    private Path applicationLayersCacheDirectory;
    @Nullable
    private EventHandlers eventHandlers;
    private boolean allowInsecureRegistries = false;
    private String toolName = "jib-core";

    public static Containerizer to(RegistryImage registryImage) {
        return new Containerizer(registryImage);
    }

    public static Containerizer to(DockerDaemonImage dockerDaemonImage) {
        return new Containerizer(dockerDaemonImage);
    }

    public static Containerizer to(TarImage tarImage) {
        return new Containerizer(tarImage);
    }

    private Containerizer(TargetImage targetImage) {
        this.targetImage = targetImage;
    }

    public Containerizer withAdditionalTag(String tag) {
        Preconditions.checkArgument((boolean)ImageReference.isValidTag(tag), (String)"invalid tag '%s'", (Object)tag);
        this.additionalTags.add(tag);
        return this;
    }

    public Containerizer setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Containerizer setBaseImageLayersCache(Path cacheDirectory) {
        this.baseImageLayersCacheDirectory = cacheDirectory;
        return this;
    }

    public Containerizer setApplicationLayersCache(Path cacheDirectory) {
        this.applicationLayersCacheDirectory = cacheDirectory;
        return this;
    }

    public Containerizer setEventHandlers(EventHandlers eventHandlers) {
        this.eventHandlers = eventHandlers;
        return this;
    }

    public Containerizer setAllowInsecureRegistries(boolean allowInsecureRegistries) {
        this.allowInsecureRegistries = allowInsecureRegistries;
        return this;
    }

    public Containerizer setToolName(String toolName) {
        this.toolName = toolName;
        return this;
    }

    TargetImage getTargetImage() {
        return this.targetImage;
    }

    Set<String> getAdditionalTags() {
        return this.additionalTags;
    }

    Optional<ExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService);
    }

    Path getBaseImageLayersCacheDirectory() {
        return this.baseImageLayersCacheDirectory;
    }

    Path getApplicationLayersCacheDirectory() throws CacheDirectoryCreationException {
        if (this.applicationLayersCacheDirectory == null) {
            try {
                Path temporaryDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
                temporaryDirectory.toFile().deleteOnExit();
                this.applicationLayersCacheDirectory = temporaryDirectory;
            }
            catch (IOException ex) {
                throw new CacheDirectoryCreationException(ex);
            }
        }
        return this.applicationLayersCacheDirectory;
    }

    Optional<EventHandlers> getEventHandlers() {
        return Optional.ofNullable(this.eventHandlers);
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    String getToolName() {
        return this.toolName;
    }
}

