/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.filesystem.RelativeUnixPath;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JavaContainerBuilder {
    public static final String DEFAULT_APP_ROOT = "/app";
    public static final String DEFAULT_WEB_APP_ROOT = "/jetty/webapps/ROOT";
    private final JibContainerBuilder jibContainerBuilder;
    private final List<String> jvmFlags = new ArrayList<String>();
    private final LinkedHashSet<LayerType> classpathOrder = new LinkedHashSet(4);
    private final List<PathPredicatePair> addedResources = new ArrayList<PathPredicatePair>();
    private final List<PathPredicatePair> addedClasses = new ArrayList<PathPredicatePair>();
    private final List<Path> addedDependencies = new ArrayList<Path>();
    private final List<Path> addedOthers = new ArrayList<Path>();
    private AbsoluteUnixPath appRoot = AbsoluteUnixPath.get("/app");
    private RelativeUnixPath classesDestination = JavaEntrypointConstructor.DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE;
    private RelativeUnixPath resourcesDestination = JavaEntrypointConstructor.DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE;
    private RelativeUnixPath dependenciesDestination = JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE;
    private RelativeUnixPath othersDestination = RelativeUnixPath.get("classpath");
    @Nullable
    private String mainClass;

    public static JavaContainerBuilder fromDistroless() {
        try {
            return JavaContainerBuilder.from(RegistryImage.named("gcr.io/distroless/java"));
        }
        catch (InvalidImageReferenceException ignored) {
            throw new IllegalStateException("Unreachable");
        }
    }

    public static JavaContainerBuilder fromDistrolessJetty() {
        try {
            return JavaContainerBuilder.from(RegistryImage.named("gcr.io/distroless/java/jetty")).setAppRoot(AbsoluteUnixPath.get(DEFAULT_WEB_APP_ROOT));
        }
        catch (InvalidImageReferenceException ignored) {
            throw new IllegalStateException("Unreachable");
        }
    }

    public static JavaContainerBuilder from(String baseImageReference) throws InvalidImageReferenceException {
        return JavaContainerBuilder.from(RegistryImage.named(baseImageReference));
    }

    public static JavaContainerBuilder from(ImageReference baseImageReference) {
        return JavaContainerBuilder.from(RegistryImage.named(baseImageReference));
    }

    public static JavaContainerBuilder from(RegistryImage registryImage) {
        return new JavaContainerBuilder(Jib.from(registryImage));
    }

    private JavaContainerBuilder(JibContainerBuilder jibContainerBuilder) {
        this.jibContainerBuilder = jibContainerBuilder;
    }

    public JavaContainerBuilder setAppRoot(String appRoot) {
        return this.setAppRoot(AbsoluteUnixPath.get(appRoot));
    }

    public JavaContainerBuilder setAppRoot(AbsoluteUnixPath appRoot) {
        this.appRoot = appRoot;
        return this;
    }

    public JavaContainerBuilder setClassesDestination(RelativeUnixPath classesDestination) {
        this.classesDestination = classesDestination;
        return this;
    }

    public JavaContainerBuilder setResourcesDestination(RelativeUnixPath resourcesDestination) {
        this.resourcesDestination = resourcesDestination;
        return this;
    }

    public JavaContainerBuilder setDependenciesDestination(RelativeUnixPath dependenciesDestination) {
        this.dependenciesDestination = dependenciesDestination;
        return this;
    }

    public JavaContainerBuilder setOthersDestination(RelativeUnixPath othersDestination) {
        this.othersDestination = othersDestination;
        return this;
    }

    public JavaContainerBuilder addDependencies(List<Path> dependencyFiles) throws IOException {
        for (Path file : dependencyFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        this.addedDependencies.addAll(dependencyFiles);
        this.classpathOrder.add(LayerType.DEPENDENCIES);
        return this;
    }

    public JavaContainerBuilder addDependencies(Path ... dependencyFiles) throws IOException {
        return this.addDependencies(Arrays.asList(dependencyFiles));
    }

    public JavaContainerBuilder addResources(Path resourceFilesDirectory) throws IOException {
        return this.addResources(resourceFilesDirectory, path -> true);
    }

    public JavaContainerBuilder addResources(Path resourceFilesDirectory, Predicate<Path> pathFilter) throws IOException {
        this.classpathOrder.add(LayerType.RESOURCES);
        return this.addDirectory(this.addedResources, resourceFilesDirectory, pathFilter);
    }

    public JavaContainerBuilder addClasses(Path classFilesDirectory) throws IOException {
        return this.addClasses(classFilesDirectory, path -> true);
    }

    public JavaContainerBuilder addClasses(Path classFilesDirectory, Predicate<Path> pathFilter) throws IOException {
        this.classpathOrder.add(LayerType.CLASSES);
        return this.addDirectory(this.addedClasses, classFilesDirectory, pathFilter);
    }

    public JavaContainerBuilder addToClasspath(List<Path> otherFiles) throws IOException {
        for (Path file : otherFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        this.classpathOrder.add(LayerType.EXTRA_FILES);
        this.addedOthers.addAll(otherFiles);
        return this;
    }

    public JavaContainerBuilder addToClasspath(Path ... otherFiles) throws IOException {
        return this.addToClasspath(Arrays.asList(otherFiles));
    }

    public JavaContainerBuilder addJvmFlag(String jvmFlag) {
        this.jvmFlags.add(jvmFlag);
        return this;
    }

    public JavaContainerBuilder addJvmFlags(List<String> jvmFlags) {
        this.jvmFlags.addAll(jvmFlags);
        return this;
    }

    public JavaContainerBuilder addJvmFlags(String ... jvmFlags) {
        this.jvmFlags.addAll(Arrays.asList(jvmFlags));
        return this;
    }

    public JavaContainerBuilder setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public JibContainerBuilder toContainerBuilder() throws IOException {
        if (this.mainClass == null && !this.jvmFlags.isEmpty()) {
            throw new IllegalStateException("Failed to construct entrypoint on JavaContainerBuilder; jvmFlags were set, but mainClass is null. Specify the main class using JavaContainerBuilder#setMainClass(String), or consider using a jib.frontend.MainClassFinder to infer the main class.");
        }
        if (this.classpathOrder.isEmpty()) {
            throw new IllegalStateException("Failed to construct entrypoint because no files were added to the JavaContainerBuilder");
        }
        EnumMap<LayerType, LayerConfiguration.Builder> layerBuilders = new EnumMap<LayerType, LayerConfiguration.Builder>(LayerType.class);
        for (PathPredicatePair pathPredicatePair : this.addedClasses) {
            this.addDirectoryContentsToLayer(layerBuilders, LayerType.CLASSES, pathPredicatePair.path, pathPredicatePair.predicate, this.appRoot.resolve(this.classesDestination));
        }
        for (PathPredicatePair pathPredicatePair : this.addedResources) {
            this.addDirectoryContentsToLayer(layerBuilders, LayerType.RESOURCES, pathPredicatePair.path, pathPredicatePair.predicate, this.appRoot.resolve(this.resourcesDestination));
        }
        List duplicates = this.addedDependencies.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.groupingBy(filename -> filename, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        for (Path file : this.addedDependencies) {
            this.addFileToLayer(layerBuilders, file.getFileName().toString().contains("SNAPSHOT") ? LayerType.SNAPSHOT_DEPENDENCIES : LayerType.DEPENDENCIES, file, this.appRoot.resolve(this.dependenciesDestination).resolve(duplicates.contains(file.getFileName().toString()) ? file.getFileName().toString().replaceFirst("\\.jar$", "-" + Files.size(file)) + ".jar" : file.getFileName().toString()));
        }
        for (Path path : this.addedOthers) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.addDirectoryContentsToLayer(layerBuilders, LayerType.EXTRA_FILES, path, ignored -> true, this.appRoot.resolve(this.othersDestination));
                continue;
            }
            this.addFileToLayer(layerBuilders, LayerType.EXTRA_FILES, path, this.appRoot.resolve(this.othersDestination).resolve(path.getFileName()));
        }
        ArrayList<LayerConfiguration> arrayList = new ArrayList<LayerConfiguration>();
        layerBuilders.forEach((type, builder) -> layers.add(builder.setName(type.getName()).build()));
        this.jibContainerBuilder.setLayers(arrayList);
        if (this.mainClass != null) {
            ArrayList<String> classpathElements = new ArrayList<String>();
            block10: for (LayerType path : this.classpathOrder) {
                switch (path) {
                    case CLASSES: {
                        classpathElements.add(this.appRoot.resolve(this.classesDestination).toString());
                        continue block10;
                    }
                    case RESOURCES: {
                        classpathElements.add(this.appRoot.resolve(this.resourcesDestination).toString());
                        continue block10;
                    }
                    case DEPENDENCIES: {
                        classpathElements.add(this.appRoot.resolve(this.dependenciesDestination).resolve("*").toString());
                        continue block10;
                    }
                    case EXTRA_FILES: {
                        classpathElements.add(this.appRoot.resolve(this.othersDestination).toString());
                        continue block10;
                    }
                }
                throw new RuntimeException("Bug in jib-core; please report the bug at https://github.com/GoogleContainerTools/jib/issues/new");
            }
            this.jibContainerBuilder.setEntrypoint(JavaEntrypointConstructor.makeEntrypoint(classpathElements, this.jvmFlags, this.mainClass));
        }
        return this.jibContainerBuilder;
    }

    private JavaContainerBuilder addDirectory(List<PathPredicatePair> addedPaths, Path directory, Predicate<Path> filter) throws NoSuchFileException, NotDirectoryException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new NoSuchFileException(directory.toString());
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new NotDirectoryException(directory.toString());
        }
        addedPaths.add(new PathPredicatePair(directory, filter));
        return this;
    }

    private void addFileToLayer(Map<LayerType, LayerConfiguration.Builder> layerBuilders, LayerType layerType, Path sourceFile, AbsoluteUnixPath pathInContainer) {
        if (!layerBuilders.containsKey((Object)layerType)) {
            layerBuilders.put(layerType, LayerConfiguration.builder());
        }
        layerBuilders.get((Object)layerType).addEntry(sourceFile, pathInContainer);
    }

    private void addDirectoryContentsToLayer(Map<LayerType, LayerConfiguration.Builder> layerBuilders, LayerType layerType, Path sourceRoot, Predicate<Path> pathFilter, AbsoluteUnixPath basePathInContainer) throws IOException {
        if (!layerBuilders.containsKey((Object)layerType)) {
            layerBuilders.put(layerType, LayerConfiguration.builder());
        }
        LayerConfiguration.Builder builder = layerBuilders.get((Object)layerType);
        new DirectoryWalker(sourceRoot).filterRoot().filter(path -> Files.isDirectory(path, new LinkOption[0]) || pathFilter.test((Path)path)).walk(path -> {
            AbsoluteUnixPath pathOnContainer = basePathInContainer.resolve(sourceRoot.relativize(path));
            builder.addEntry(path, pathOnContainer);
        });
    }

    @VisibleForTesting
    public static enum LayerType {
        DEPENDENCIES("dependencies"),
        SNAPSHOT_DEPENDENCIES("snapshot dependencies"),
        RESOURCES("resources"),
        CLASSES("classes"),
        EXTRA_FILES("extra files");

        private final String name;

        private LayerType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class PathPredicatePair {
        private final Path path;
        private final Predicate<Path> predicate;

        private PathPredicatePair(Path path, Predicate<Path> predicate) {
            this.path = path;
            this.predicate = predicate;
        }
    }
}

