/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.SourceImage;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.event.DefaultEventDispatcher;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.ImageFormat;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class JibContainerBuilder {
    private final ContainerConfiguration.Builder containerConfigurationBuilder = ContainerConfiguration.builder();
    private final BuildConfiguration.Builder buildConfigurationBuilder;
    private List<LayerConfiguration> layerConfigurations = new ArrayList<LayerConfiguration>();

    private static String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    JibContainerBuilder(SourceImage baseImage) {
        this(baseImage, BuildConfiguration.builder());
    }

    @VisibleForTesting
    JibContainerBuilder(SourceImage baseImage, BuildConfiguration.Builder buildConfigurationBuilder) {
        this.buildConfigurationBuilder = buildConfigurationBuilder;
        buildConfigurationBuilder.setBaseImageConfiguration(baseImage.toImageConfiguration());
    }

    public JibContainerBuilder addLayer(List<Path> files, AbsoluteUnixPath pathInContainer) throws IOException {
        LayerConfiguration.Builder layerConfigurationBuilder = LayerConfiguration.builder();
        for (Path file : files) {
            layerConfigurationBuilder.addEntryRecursive(file, pathInContainer.resolve(file.getFileName()));
        }
        return this.addLayer(layerConfigurationBuilder.build());
    }

    public JibContainerBuilder addLayer(List<Path> files, String pathInContainer) throws IOException {
        return this.addLayer(files, AbsoluteUnixPath.get(pathInContainer));
    }

    public JibContainerBuilder addLayer(LayerConfiguration layerConfiguration) {
        this.layerConfigurations.add(layerConfiguration);
        return this;
    }

    public JibContainerBuilder setLayers(List<LayerConfiguration> layerConfigurations) {
        this.layerConfigurations = new ArrayList<LayerConfiguration>(layerConfigurations);
        return this;
    }

    public JibContainerBuilder setLayers(LayerConfiguration ... layerConfigurations) {
        return this.setLayers(Arrays.asList(layerConfigurations));
    }

    public JibContainerBuilder setEntrypoint(@Nullable List<String> entrypoint) {
        this.containerConfigurationBuilder.setEntrypoint(entrypoint);
        return this;
    }

    public JibContainerBuilder setEntrypoint(String ... entrypoint) {
        return this.setEntrypoint(Arrays.asList(entrypoint));
    }

    public JibContainerBuilder setProgramArguments(@Nullable List<String> programArguments) {
        this.containerConfigurationBuilder.setProgramArguments(programArguments);
        return this;
    }

    public JibContainerBuilder setProgramArguments(String ... programArguments) {
        return this.setProgramArguments(Arrays.asList(programArguments));
    }

    public JibContainerBuilder setEnvironment(Map<String, String> environmentMap) {
        this.containerConfigurationBuilder.setEnvironment(environmentMap);
        return this;
    }

    public JibContainerBuilder addEnvironmentVariable(String name, String value) {
        this.containerConfigurationBuilder.addEnvironment(name, value);
        return this;
    }

    public JibContainerBuilder setVolumes(Set<AbsoluteUnixPath> volumes) {
        this.containerConfigurationBuilder.setVolumes(volumes);
        return this;
    }

    public JibContainerBuilder setVolumes(AbsoluteUnixPath ... volumes) {
        return this.setVolumes(new HashSet<AbsoluteUnixPath>(Arrays.asList(volumes)));
    }

    public JibContainerBuilder addVolume(AbsoluteUnixPath volume) {
        this.containerConfigurationBuilder.addVolume(volume);
        return this;
    }

    public JibContainerBuilder setExposedPorts(Set<Port> ports) {
        this.containerConfigurationBuilder.setExposedPorts(ports);
        return this;
    }

    public JibContainerBuilder setExposedPorts(Port ... ports) {
        return this.setExposedPorts(new HashSet<Port>(Arrays.asList(ports)));
    }

    public JibContainerBuilder addExposedPort(Port port) {
        this.containerConfigurationBuilder.addExposedPort(port);
        return this;
    }

    public JibContainerBuilder setLabels(Map<String, String> labelMap) {
        this.containerConfigurationBuilder.setLabels(labelMap);
        return this;
    }

    public JibContainerBuilder addLabel(String key, String value) {
        this.containerConfigurationBuilder.addLabel(key, value);
        return this;
    }

    public JibContainerBuilder setFormat(ImageFormat imageFormat) {
        this.buildConfigurationBuilder.setTargetFormat(imageFormat.getManifestTemplateClass());
        return this;
    }

    public JibContainerBuilder setCreationTime(Instant creationTime) {
        this.containerConfigurationBuilder.setCreationTime(creationTime);
        return this;
    }

    public JibContainerBuilder setUser(@Nullable String user) {
        this.containerConfigurationBuilder.setUser(user);
        return this;
    }

    public JibContainerBuilder setWorkingDirectory(@Nullable AbsoluteUnixPath workingDirectory) {
        this.containerConfigurationBuilder.setWorkingDirectory(workingDirectory);
        return this;
    }

    public JibContainer containerize(Containerizer containerizer) throws InterruptedException, RegistryException, IOException, CacheDirectoryCreationException, ExecutionException {
        return this.containerize(containerizer, Executors::newCachedThreadPool);
    }

    @VisibleForTesting
    JibContainer containerize(Containerizer containerizer, Supplier<ExecutorService> defaultExecutorServiceFactory) throws IOException, CacheDirectoryCreationException, InterruptedException, RegistryException, ExecutionException {
        boolean shutdownExecutorService = !containerizer.getExecutorService().isPresent();
        ExecutorService executorService = containerizer.getExecutorService().orElseGet(defaultExecutorServiceFactory);
        BuildConfiguration buildConfiguration = this.toBuildConfiguration(containerizer, executorService);
        buildConfiguration.getEventDispatcher().dispatch(LogEvent.info("Containerizing application with the following files:"));
        for (LayerConfiguration layerConfiguration : this.layerConfigurations) {
            if (layerConfiguration.getLayerEntries().isEmpty()) continue;
            buildConfiguration.getEventDispatcher().dispatch(LogEvent.info("\t" + JibContainerBuilder.capitalizeFirstLetter(layerConfiguration.getName()) + ":"));
            for (LayerEntry layerEntry : layerConfiguration.getLayerEntries()) {
                buildConfiguration.getEventDispatcher().dispatch(LogEvent.info("\t\t" + layerEntry.getSourceFile()));
            }
        }
        try {
            BuildResult result = containerizer.getTargetImage().toBuildSteps(buildConfiguration).run();
            JibContainer jibContainer = new JibContainer(result.getImageDigest(), result.getImageId());
            return jibContainer;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RegistryException) {
                throw (RegistryException)ex.getCause();
            }
            throw ex;
        }
        finally {
            if (shutdownExecutorService) {
                executorService.shutdown();
            }
        }
    }

    @VisibleForTesting
    public BuildConfiguration toBuildConfiguration(Containerizer containerizer, ExecutorService executorService) throws CacheDirectoryCreationException, IOException {
        this.buildConfigurationBuilder.setTargetImageConfiguration(containerizer.getTargetImage().toImageConfiguration()).setAdditionalTargetImageTags(containerizer.getAdditionalTags()).setBaseImageLayersCacheDirectory(containerizer.getBaseImageLayersCacheDirectory()).setApplicationLayersCacheDirectory(containerizer.getApplicationLayersCacheDirectory()).setContainerConfiguration(this.containerConfigurationBuilder.build()).setLayerConfigurations(this.layerConfigurations).setAllowInsecureRegistries(containerizer.getAllowInsecureRegistries()).setToolName(containerizer.getToolName()).setExecutorService(executorService);
        containerizer.getEventHandlers().ifPresent(eventHandlers -> this.buildConfigurationBuilder.setEventDispatcher(new DefaultEventDispatcher((EventHandlers)eventHandlers)));
        return this.buildConfigurationBuilder.build();
    }
}

