/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.async;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class AsyncDependencies {
    private final ListeningExecutorService listeningExecutorService;
    private final List<ListenableFuture<?>> futures = new ArrayList();

    public static AsyncDependencies using(ListeningExecutorService listeningExecutorService) {
        return new AsyncDependencies(listeningExecutorService);
    }

    private AsyncDependencies(ListeningExecutorService listeningExecutorService) {
        this.listeningExecutorService = listeningExecutorService;
    }

    public AsyncDependencies addStep(AsyncStep<?> asyncStep) {
        this.futures.add(asyncStep.getFuture());
        return this;
    }

    public AsyncDependencies addSteps(List<? extends AsyncStep<?>> asyncSteps) {
        asyncSteps.forEach(this::addStep);
        return this;
    }

    public <C> ListenableFuture<C> whenAllSucceed(Callable<C> combiner) {
        return Futures.whenAllSucceed(this.futures).call(combiner, (Executor)this.listeningExecutorService);
    }
}

