/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.BuildStepType;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.progress.Allocation;
import com.google.common.base.Preconditions;
import java.io.Closeable;

public class ProgressEventDispatcher
implements Closeable {
    private final EventDispatcher eventDispatcher;
    private final Allocation allocation;
    private final BuildStepType buildStepType;
    private long remainingAllocationUnits;
    private boolean closed = false;

    public static ProgressEventDispatcher newRoot(EventDispatcher eventDispatcher, String description, long allocationUnits) {
        return ProgressEventDispatcher.newProgressEventDispatcher(eventDispatcher, Allocation.newRoot(description, allocationUnits), BuildStepType.ALL);
    }

    private static ProgressEventDispatcher newProgressEventDispatcher(EventDispatcher eventDispatcher, Allocation allocation, BuildStepType buildStepType) {
        ProgressEventDispatcher progressEventDispatcher = new ProgressEventDispatcher(eventDispatcher, allocation, buildStepType);
        progressEventDispatcher.dispatchProgress(0L);
        return progressEventDispatcher;
    }

    private ProgressEventDispatcher(EventDispatcher eventDispatcher, Allocation allocation, BuildStepType buildStepType) {
        this.eventDispatcher = eventDispatcher;
        this.allocation = allocation;
        this.buildStepType = buildStepType;
        this.remainingAllocationUnits = allocation.getAllocationUnits();
    }

    public Factory newChildProducer() {
        this.decrementRemainingAllocationUnits(1L);
        return new Factory(){
            private boolean used = false;

            @Override
            public ProgressEventDispatcher create(BuildStepType buildStepType, String description, long allocationUnits) {
                Preconditions.checkState((!this.used ? 1 : 0) != 0);
                this.used = true;
                return ProgressEventDispatcher.newProgressEventDispatcher(ProgressEventDispatcher.this.eventDispatcher, ProgressEventDispatcher.this.allocation.newChild(description, allocationUnits), buildStepType);
            }
        };
    }

    @Override
    public void close() {
        if (this.remainingAllocationUnits > 0L) {
            this.dispatchProgress(this.remainingAllocationUnits);
        }
        this.closed = true;
    }

    public void dispatchProgress(long progressUnits) {
        long unitsDecremented = this.decrementRemainingAllocationUnits(progressUnits);
        this.eventDispatcher.dispatch(new ProgressEvent(this.allocation, unitsDecremented, this.buildStepType));
    }

    private long decrementRemainingAllocationUnits(long units) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.remainingAllocationUnits > units) {
            this.remainingAllocationUnits -= units;
            return units;
        }
        long actualDecrement = this.remainingAllocationUnits;
        this.remainingAllocationUnits = 0L;
        return actualDecrement;
    }

    @FunctionalInterface
    public static interface Factory {
        public ProgressEventDispatcher create(BuildStepType var1, String var2, long var3);
    }
}

