/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.BuildStepType;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class AuthenticatePushStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating with push to %s";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep;
    private final ListenableFuture<Authorization> listenableFuture;

    AuthenticatePushStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.retrieveTargetRegistryCredentialsStep = retrieveTargetRegistryCredentialsStep;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(retrieveTargetRegistryCredentialsStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    @Nullable
    public Authorization call() throws ExecutionException, RegistryAuthenticationFailedException, IOException, RegistryException {
        String registry = this.buildConfiguration.getTargetImageConfiguration().getImageRegistry();
        Throwable throwable = null;
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create(BuildStepType.AUTHENTICATE_PUSH, "authenticating push to " + registry, 1L);){
            Authorization authorization;
            Credential registryCredential;
            Throwable throwable2;
            TimerEventDispatcher ignored2;
            block13: {
                ignored2 = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), String.format(DESCRIPTION, registry));
                throwable2 = null;
                registryCredential = NonBlockingSteps.get(this.retrieveTargetRegistryCredentialsStep);
                RegistryAuthenticator registryAuthenticator = RegistryAuthenticator.initializer(this.buildConfiguration.getEventDispatcher(), registry, this.buildConfiguration.getTargetImageConfiguration().getImageRepository()).setAllowInsecureRegistries(this.buildConfiguration.getAllowInsecureRegistries()).setUserAgentSuffix(this.buildConfiguration.getToolName()).initialize();
                if (registryAuthenticator == null) break block13;
                Authorization authorization2 = registryAuthenticator.setCredential(registryCredential).authenticatePush();
                AuthenticatePushStep.$closeResource(throwable2, ignored2);
                return authorization2;
            }
            try {
                authorization = registryCredential == null || registryCredential.isOAuth2RefreshToken() ? null : Authorizations.withBasicCredentials(registryCredential.getUsername(), registryCredential.getPassword());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AuthenticatePushStep.$closeResource(throwable2, ignored2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AuthenticatePushStep.$closeResource(throwable2, ignored2);
            return authorization;
        }
    }
}

