/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.BuildStepType;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.ProgressEventDispatcherContainer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class PullBaseImageStep
implements AsyncStep<BaseImageWithAuthorization>,
Callable<BaseImageWithAuthorization> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final ListenableFuture<BaseImageWithAuthorization> listenableFuture;

    PullBaseImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<BaseImageWithAuthorization> getFuture() {
        return this.listenableFuture;
    }

    /*
     * Exception decompiling
     */
    @Override
    public BaseImageWithAuthorization call() throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, ExecutionException, BadContainerConfigurationFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Image<Layer> pullBaseImage(@Nullable Authorization registryAuthorization, ProgressEventDispatcher progressEventDispatcher) throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, BadContainerConfigurationFormatException {
        RegistryClient registryClient = this.buildConfiguration.newBaseImageRegistryClientFactory().setAuthorization(registryAuthorization).newRegistryClient();
        ManifestTemplate manifestTemplate = registryClient.pullManifest(this.buildConfiguration.getBaseImageConfiguration().getImageTag());
        switch (manifestTemplate.getSchemaVersion()) {
            case 1: {
                V21ManifestTemplate v21ManifestTemplate = (V21ManifestTemplate)manifestTemplate;
                return JsonToImageTranslator.toImage(v21ManifestTemplate);
            }
            case 2: {
                V22ManifestTemplate v22ManifestTemplate = (V22ManifestTemplate)manifestTemplate;
                if (v22ManifestTemplate.getContainerConfiguration() == null || v22ManifestTemplate.getContainerConfiguration().getDigest() == null) {
                    throw new UnknownManifestFormatException("Invalid container configuration in Docker V2.2 manifest: \n" + Blobs.writeToString(JsonTemplateMapper.toBlob(v22ManifestTemplate)));
                }
                DescriptorDigest containerConfigurationDigest = v22ManifestTemplate.getContainerConfiguration().getDigest();
                try (ProgressEventDispatcherContainer progressEventDispatcherContainer = new ProgressEventDispatcherContainer(progressEventDispatcher.newChildProducer(), "pull container configuration " + containerConfigurationDigest, BuildStepType.PULL_BASE_IMAGE);){
                    String containerConfigurationString = Blobs.writeToString(registryClient.pullBlob(containerConfigurationDigest, progressEventDispatcherContainer::initializeWithBlobSize, progressEventDispatcherContainer));
                    ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(containerConfigurationString, ContainerConfigurationTemplate.class);
                    Image<Layer> image = JsonToImageTranslator.toImage(v22ManifestTemplate, containerConfigurationTemplate);
                    return image;
                }
            }
        }
        throw new IllegalStateException("Unknown manifest schema version");
    }

    static class BaseImageWithAuthorization {
        private final Image<Layer> baseImage;
        @Nullable
        private final Authorization baseImageAuthorization;

        @VisibleForTesting
        BaseImageWithAuthorization(Image<Layer> baseImage, @Nullable Authorization baseImageAuthorization) {
            this.baseImage = baseImage;
            this.baseImageAuthorization = baseImageAuthorization;
        }

        Image<Layer> getBaseImage() {
            return this.baseImage;
        }

        @Nullable
        Authorization getBaseImageAuthorization() {
            return this.baseImageAuthorization;
        }
    }
}

