/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildStepType;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.http.BlobProgressListener;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class PushBlobStep
implements AsyncStep<BlobDescriptor>,
Callable<BlobDescriptor> {
    private static final String DESCRIPTION = "Pushing BLOB ";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDipatcherFactory;
    private final AuthenticatePushStep authenticatePushStep;
    private final BlobDescriptor blobDescriptor;
    private final Blob blob;
    private final BuildStepType buildStepType;
    private final ListenableFuture<BlobDescriptor> listenableFuture;

    PushBlobStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDipatcherFactory, AuthenticatePushStep authenticatePushStep, BlobDescriptor blobDescriptor, Blob blob, BuildStepType buildStepType) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDipatcherFactory = progressEventDipatcherFactory;
        this.authenticatePushStep = authenticatePushStep;
        this.blobDescriptor = blobDescriptor;
        this.blob = blob;
        this.buildStepType = buildStepType;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(authenticatePushStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<BlobDescriptor> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BlobDescriptor call() throws IOException, RegistryException, ExecutionException {
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = this.progressEventDipatcherFactory.create(this.buildStepType, "pushing blob " + this.blobDescriptor.getDigest(), this.blobDescriptor.getSize());){
            BlobDescriptor blobDescriptor;
            RegistryClient registryClient;
            Throwable throwable2;
            TimerEventDispatcher ignored;
            block13: {
                ignored = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), DESCRIPTION + this.blobDescriptor);
                throwable2 = null;
                registryClient = this.buildConfiguration.newTargetImageRegistryClientFactory().setAuthorization(NonBlockingSteps.get(this.authenticatePushStep)).newRegistryClient();
                if (registryClient.checkBlob(this.blobDescriptor.getDigest()) == null) break block13;
                this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.info("BLOB : " + this.blobDescriptor + " already exists on registry"));
                BlobDescriptor blobDescriptor2 = this.blobDescriptor;
                PushBlobStep.$closeResource(throwable2, ignored);
                return blobDescriptor2;
            }
            try {
                registryClient.pushBlob(this.blobDescriptor.getDigest(), this.blob, null, new ForwardingProgressListener(progressEventDispatcher));
                blobDescriptor = this.blobDescriptor;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        PushBlobStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            PushBlobStep.$closeResource(throwable2, ignored);
            return blobDescriptor;
        }
    }

    private static class ForwardingProgressListener
    implements BlobProgressListener {
        private final ProgressEventDispatcher progressEventDispatcher;

        private ForwardingProgressListener(ProgressEventDispatcher progressEventDispatcher) {
            this.progressEventDispatcher = progressEventDispatcher;
        }

        @Override
        public void handleByteCount(long byteCount) {
            this.progressEventDispatcher.dispatchProgress(byteCount);
        }

        @Override
        public Duration getDelayBetweenCallbacks() {
            return Duration.ofMillis(100L);
        }
    }
}

