/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildStepType;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushLayersStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class PushImageStep
implements AsyncStep<BuildResult>,
Callable<BuildResult> {
    private static final String DESCRIPTION = "Pushing new image";
    private final BuildConfiguration buildConfiguration;
    private final ListeningExecutorService listeningExecutorService;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final AuthenticatePushStep authenticatePushStep;
    private final PushLayersStep pushBaseImageLayersStep;
    private final PushLayersStep pushApplicationLayersStep;
    private final PushContainerConfigurationStep pushContainerConfigurationStep;
    private final BuildImageStep buildImageStep;
    private final ListenableFuture<BuildResult> listenableFuture;

    PushImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, AuthenticatePushStep authenticatePushStep, PushLayersStep pushBaseImageLayersStep, PushLayersStep pushApplicationLayersStep, PushContainerConfigurationStep pushContainerConfigurationStep, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.authenticatePushStep = authenticatePushStep;
        this.pushBaseImageLayersStep = pushBaseImageLayersStep;
        this.pushApplicationLayersStep = pushApplicationLayersStep;
        this.pushContainerConfigurationStep = pushContainerConfigurationStep;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(pushBaseImageLayersStep).addStep(pushApplicationLayersStep).addStep(pushContainerConfigurationStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<BuildResult> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BuildResult call() throws ExecutionException, InterruptedException {
        return (BuildResult)AsyncDependencies.using(this.listeningExecutorService).addStep(this.authenticatePushStep).addSteps((List)NonBlockingSteps.get(this.pushBaseImageLayersStep)).addSteps((List)NonBlockingSteps.get(this.pushApplicationLayersStep)).addStep(NonBlockingSteps.get(this.pushContainerConfigurationStep)).addStep(NonBlockingSteps.get(this.buildImageStep)).whenAllSucceed(this::afterPushSteps).get();
    }

    private BuildResult afterPushSteps() throws ExecutionException, InterruptedException {
        AsyncDependencies dependencies = AsyncDependencies.using(this.listeningExecutorService);
        for (AsyncStep pushBaseImageLayerStep : NonBlockingSteps.get(this.pushBaseImageLayersStep)) {
            dependencies.addStep((AsyncStep)NonBlockingSteps.get(pushBaseImageLayerStep));
        }
        for (AsyncStep pushApplicationLayerStep : NonBlockingSteps.get(this.pushApplicationLayersStep)) {
            dependencies.addStep((AsyncStep)NonBlockingSteps.get(pushApplicationLayerStep));
        }
        return (BuildResult)dependencies.addStep(NonBlockingSteps.get(NonBlockingSteps.get(this.pushContainerConfigurationStep))).whenAllSucceed(this::afterAllPushed).get();
    }

    private BuildResult afterAllPushed() throws ExecutionException, IOException, InterruptedException {
        ImmutableSet<String> targetImageTags = this.buildConfiguration.getAllTargetImageTags();
        ProgressEventDispatcher progressEventDispatcher = this.progressEventDispatcherFactory.create(BuildStepType.PUSH_IMAGE, "pushing image manifest", targetImageTags.size());
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), DESCRIPTION);){
            RegistryClient registryClient = this.buildConfiguration.newTargetImageRegistryClientFactory().setAuthorization(NonBlockingSteps.get(this.authenticatePushStep)).newRegistryClient();
            ImageToJsonTranslator imageToJsonTranslator = new ImageToJsonTranslator(NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep)));
            BlobDescriptor containerConfigurationBlobDescriptor = (BlobDescriptor)NonBlockingSteps.get(NonBlockingSteps.get(NonBlockingSteps.get(this.pushContainerConfigurationStep)));
            BuildableManifestTemplate manifestTemplate = imageToJsonTranslator.getManifestTemplate(this.buildConfiguration.getTargetFormat(), containerConfigurationBlobDescriptor);
            ArrayList<ListenableFuture> pushAllTagsFutures = new ArrayList<ListenableFuture>();
            for (String tag : targetImageTags) {
                ProgressEventDispatcher.Factory progressEventDispatcherFactory = progressEventDispatcher.newChildProducer();
                pushAllTagsFutures.add(this.listeningExecutorService.submit(() -> {
                    ProgressEventDispatcher ignored2 = progressEventDispatcherFactory.create(BuildStepType.PUSH_IMAGE, "tagging with " + tag, 1L);
                    Throwable throwable = null;
                    try {
                        this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.info("Tagging with " + tag + "..."));
                        registryClient.pushManifest(manifestTemplate, tag);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored2 != null) {
                            PushImageStep.$closeResource(throwable, ignored2);
                        }
                    }
                    return null;
                }));
            }
            DescriptorDigest imageDigest = JsonTemplateMapper.toBlob(manifestTemplate).writeTo(ByteStreams.nullOutputStream()).getDigest();
            DescriptorDigest imageId = containerConfigurationBlobDescriptor.getDigest();
            BuildResult result = new BuildResult(imageDigest, imageId);
            BuildResult buildResult = (BuildResult)Futures.whenAllSucceed(pushAllTagsFutures).call(() -> {
                progressEventDispatcher.close();
                return result;
            }, (Executor)this.listeningExecutorService).get();
            return buildResult;
        }
    }
}

