/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.DefaultCacheStorageFiles;
import com.google.cloud.tools.jib.cache.DefaultCachedLayer;
import com.google.cloud.tools.jib.cache.UncompressedCacheWrite;
import com.google.cloud.tools.jib.filesystem.TemporaryDirectory;
import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class DefaultCacheStorageWriter {
    private final DefaultCacheStorageFiles defaultCacheStorageFiles;

    private static void moveIfDoesNotExist(Path source, Path destination) throws IOException {
        block3: {
            if (Files.exists(destination, new LinkOption[0])) {
                return;
            }
            try {
                Files.move(source, destination, new CopyOption[0]);
            }
            catch (FileSystemException ex) {
                if (Files.exists(destination, new LinkOption[0])) break block3;
                throw ex;
            }
        }
    }

    private static DescriptorDigest getDiffIdByDecompressingFile(Path compressedFile) throws IOException {
        try (CountingDigestOutputStream diffIdCaptureOutputStream = new CountingDigestOutputStream(ByteStreams.nullOutputStream());){
            try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(compressedFile, new OpenOption[0]));
                 GZIPInputStream decompressorStream = new GZIPInputStream(fileInputStream);){
                ByteStreams.copy((InputStream)decompressorStream, (OutputStream)diffIdCaptureOutputStream);
            }
            DescriptorDigest descriptorDigest = diffIdCaptureOutputStream.toBlobDescriptor().getDigest();
            return descriptorDigest;
        }
    }

    DefaultCacheStorageWriter(DefaultCacheStorageFiles defaultCacheStorageFiles) {
        this.defaultCacheStorageFiles = defaultCacheStorageFiles;
    }

    CachedLayer write(Blob compressedLayerBlob) throws IOException {
        Files.createDirectories(this.defaultCacheStorageFiles.getLayersDirectory(), new FileAttribute[0]);
        Files.createDirectories(this.defaultCacheStorageFiles.getTemporaryDirectory(), new FileAttribute[0]);
        try (TemporaryDirectory temporaryDirectory = new TemporaryDirectory(this.defaultCacheStorageFiles.getTemporaryDirectory());){
            Path temporaryLayerDirectory = temporaryDirectory.getDirectory();
            WrittenLayer writtenLayer = this.writeCompressedLayerBlobToDirectory(compressedLayerBlob, temporaryLayerDirectory);
            DefaultCacheStorageWriter.moveIfDoesNotExist(temporaryLayerDirectory, this.defaultCacheStorageFiles.getLayerDirectory(writtenLayer.layerDigest));
            Path layerFile = this.defaultCacheStorageFiles.getLayerFile(writtenLayer.layerDigest, writtenLayer.layerDiffId);
            CachedLayer cachedLayer = DefaultCachedLayer.builder().setLayerDigest(writtenLayer.layerDigest).setLayerDiffId(writtenLayer.layerDiffId).setLayerSize(writtenLayer.layerSize).setLayerBlob(Blobs.from(layerFile)).build();
            return cachedLayer;
        }
    }

    CachedLayer write(UncompressedCacheWrite uncompressedCacheWrite) throws IOException {
        Files.createDirectories(this.defaultCacheStorageFiles.getLayersDirectory(), new FileAttribute[0]);
        Files.createDirectories(this.defaultCacheStorageFiles.getTemporaryDirectory(), new FileAttribute[0]);
        try (TemporaryDirectory temporaryDirectory = new TemporaryDirectory(this.defaultCacheStorageFiles.getTemporaryDirectory());){
            Path temporaryLayerDirectory = temporaryDirectory.getDirectory();
            WrittenLayer writtenLayer = this.writeUncompressedLayerBlobToDirectory(uncompressedCacheWrite.getUncompressedLayerBlob(), temporaryLayerDirectory);
            DefaultCacheStorageWriter.moveIfDoesNotExist(temporaryLayerDirectory, this.defaultCacheStorageFiles.getLayerDirectory(writtenLayer.layerDigest));
            Path layerFile = this.defaultCacheStorageFiles.getLayerFile(writtenLayer.layerDigest, writtenLayer.layerDiffId);
            DefaultCachedLayer.Builder cachedLayerBuilder = DefaultCachedLayer.builder().setLayerDigest(writtenLayer.layerDigest).setLayerDiffId(writtenLayer.layerDiffId).setLayerSize(writtenLayer.layerSize).setLayerBlob(Blobs.from(layerFile));
            if (uncompressedCacheWrite.getSelector().isPresent()) {
                this.writeSelector(uncompressedCacheWrite.getSelector().get(), writtenLayer.layerDigest);
            }
            CachedLayer cachedLayer = cachedLayerBuilder.build();
            return cachedLayer;
        }
    }

    private WrittenLayer writeCompressedLayerBlobToDirectory(Blob compressedLayerBlob, Path layerDirectory) throws IOException {
        BlobDescriptor layerBlobDescriptor;
        Path temporaryLayerFile = this.defaultCacheStorageFiles.getTemporaryLayerFile(layerDirectory);
        try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(temporaryLayerFile, new OpenOption[0]));){
            layerBlobDescriptor = compressedLayerBlob.writeTo(fileOutputStream);
        }
        DescriptorDigest layerDiffId = DefaultCacheStorageWriter.getDiffIdByDecompressingFile(temporaryLayerFile);
        Path layerFile = layerDirectory.resolve(this.defaultCacheStorageFiles.getLayerFilename(layerDiffId));
        DefaultCacheStorageWriter.moveIfDoesNotExist(temporaryLayerFile, layerFile);
        return new WrittenLayer(layerBlobDescriptor.getDigest(), layerDiffId, layerBlobDescriptor.getSize());
    }

    private WrittenLayer writeUncompressedLayerBlobToDirectory(Blob uncompressedLayerBlob, Path layerDirectory) throws IOException {
        Path temporaryLayerFile = this.defaultCacheStorageFiles.getTemporaryLayerFile(layerDirectory);
        try (CountingDigestOutputStream compressedDigestOutputStream = new CountingDigestOutputStream(new BufferedOutputStream(Files.newOutputStream(temporaryLayerFile, new OpenOption[0])));){
            GZIPOutputStream compressorStream = new GZIPOutputStream(compressedDigestOutputStream);
            DescriptorDigest layerDiffId = uncompressedLayerBlob.writeTo(compressorStream).getDigest();
            compressorStream.close();
            BlobDescriptor compressedBlobDescriptor = compressedDigestOutputStream.toBlobDescriptor();
            DescriptorDigest layerDigest = compressedBlobDescriptor.getDigest();
            long layerSize = compressedBlobDescriptor.getSize();
            Path layerFile = layerDirectory.resolve(this.defaultCacheStorageFiles.getLayerFilename(layerDiffId));
            DefaultCacheStorageWriter.moveIfDoesNotExist(temporaryLayerFile, layerFile);
            WrittenLayer writtenLayer = new WrittenLayer(layerDigest, layerDiffId, layerSize);
            return writtenLayer;
        }
    }

    private void writeSelector(DescriptorDigest selector, DescriptorDigest layerDigest) throws IOException {
        Path selectorFile = this.defaultCacheStorageFiles.getSelectorFile(selector);
        Files.createDirectories(selectorFile.getParent(), new FileAttribute[0]);
        Path temporarySelectorFile = Files.createTempFile(null, null, new FileAttribute[0]);
        temporarySelectorFile.toFile().deleteOnExit();
        Blobs.writeToFileWithLock(Blobs.from(layerDigest.getHash()), temporarySelectorFile);
        try {
            Files.move(temporarySelectorFile, selectorFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException ignored) {
            Files.move(temporarySelectorFile, selectorFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static class WrittenLayer {
        private final DescriptorDigest layerDigest;
        private final DescriptorDigest layerDiffId;
        private final long layerSize;

        private WrittenLayer(DescriptorDigest layerDigest, DescriptorDigest layerDiffId, long layerSize) {
            this.layerDigest = layerDigest;
            this.layerDiffId = layerDiffId;
            this.layerSize = layerSize;
        }
    }
}

