/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class LayerEntriesSelector {
    @VisibleForTesting
    static List<LayerEntryTemplate> toSortedJsonTemplates(List<LayerEntry> layerEntries) throws IOException {
        ArrayList<LayerEntryTemplate> jsonTemplates = new ArrayList<LayerEntryTemplate>();
        for (LayerEntry entry : layerEntries) {
            jsonTemplates.add(new LayerEntryTemplate(entry));
        }
        Collections.sort(jsonTemplates);
        return jsonTemplates;
    }

    static DescriptorDigest generateSelector(ImmutableList<LayerEntry> layerEntries) throws IOException {
        return JsonTemplateMapper.toBlob(LayerEntriesSelector.toSortedJsonTemplates(layerEntries)).writeTo(ByteStreams.nullOutputStream()).getDigest();
    }

    private LayerEntriesSelector() {
    }

    @VisibleForTesting
    static class LayerEntryTemplate
    implements JsonTemplate,
    Comparable<LayerEntryTemplate> {
        private final String sourceFile;
        private final String extractionPath;
        private final Instant lastModifiedTime;
        private final String permissions;

        @VisibleForTesting
        LayerEntryTemplate(LayerEntry layerEntry) throws IOException {
            this.sourceFile = layerEntry.getSourceFile().toAbsolutePath().toString();
            this.extractionPath = layerEntry.getExtractionPath().toString();
            this.lastModifiedTime = Files.getLastModifiedTime(layerEntry.getSourceFile(), new LinkOption[0]).toInstant();
            this.permissions = layerEntry.getPermissions().toOctalString();
        }

        @Override
        public int compareTo(LayerEntryTemplate otherLayerEntryTemplate) {
            int sourceFileComparison = this.sourceFile.compareTo(otherLayerEntryTemplate.sourceFile);
            if (sourceFileComparison != 0) {
                return sourceFileComparison;
            }
            int extractionPathComparison = this.extractionPath.compareTo(otherLayerEntryTemplate.extractionPath);
            if (extractionPathComparison != 0) {
                return extractionPathComparison;
            }
            int lastModifiedTimeComparison = this.lastModifiedTime.compareTo(otherLayerEntryTemplate.lastModifiedTime);
            if (lastModifiedTimeComparison != 0) {
                return lastModifiedTimeComparison;
            }
            return this.permissions.compareTo(otherLayerEntryTemplate.permissions);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LayerEntryTemplate)) {
                return false;
            }
            LayerEntryTemplate otherLayerEntryTemplate = (LayerEntryTemplate)other;
            return this.sourceFile.equals(otherLayerEntryTemplate.sourceFile) && this.extractionPath.equals(otherLayerEntryTemplate.extractionPath) && this.lastModifiedTime.equals(otherLayerEntryTemplate.lastModifiedTime) && this.permissions.equals(otherLayerEntryTemplate.permissions);
        }

        public int hashCode() {
            return Objects.hash(this.sourceFile, this.extractionPath, this.lastModifiedTime, this.permissions);
        }
    }
}

