/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration.credentials;

import java.util.Objects;

public class Credential {
    private static final String OAUTH2_TOKEN_USER_NAME = "<token>";
    private final String username;
    private final String password;

    public static Credential from(String username, String password) {
        return new Credential(username, password);
    }

    private Credential(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isOAuth2RefreshToken() {
        return OAUTH2_TOKEN_USER_NAME.equals(this.username);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Credential)) {
            return false;
        }
        Credential otherCredential = (Credential)other;
        return this.username.equals(otherCredential.username) && this.password.equals(otherCredential.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public String toString() {
        return this.username + ":" + this.password;
    }
}

