/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.configuration.credentials.CredentialRetriever;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.JibEvent;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperNotFoundException;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperUnhandledServerUrlException;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;

public class CredentialRetrieverFactory {
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final EventDispatcher eventDispatcher;
    private final ImageReference imageReference;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;

    public static CredentialRetrieverFactory forImage(ImageReference imageReference, EventDispatcher eventDispatcher) {
        return new CredentialRetrieverFactory(imageReference, eventDispatcher, DockerCredentialHelper::new);
    }

    public static CredentialRetrieverFactory forImage(ImageReference imageReference) {
        return new CredentialRetrieverFactory(imageReference, ignored -> {}, DockerCredentialHelper::new);
    }

    @VisibleForTesting
    CredentialRetrieverFactory(ImageReference imageReference, EventDispatcher eventDispatcher, DockerCredentialHelperFactory dockerCredentialHelperFactory) {
        this.imageReference = imageReference;
        this.eventDispatcher = eventDispatcher;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
    }

    public CredentialRetriever known(Credential credential, String credentialSource) {
        return () -> {
            this.logGotCredentialsFrom(credentialSource);
            return Optional.of(credential);
        };
    }

    public CredentialRetriever dockerCredentialHelper(String credentialHelper) {
        return this.dockerCredentialHelper(Paths.get(credentialHelper, new String[0]));
    }

    public CredentialRetriever dockerCredentialHelper(Path credentialHelper) {
        return () -> {
            this.dispatchEvent(LogEvent.info("Checking credentials from " + credentialHelper));
            try {
                return Optional.of(this.retrieveFromDockerCredentialHelper(credentialHelper));
            }
            catch (CredentialHelperUnhandledServerUrlException ex) {
                this.dispatchEvent(LogEvent.info("No credentials for " + this.imageReference.getRegistry() + " in " + credentialHelper));
                return Optional.empty();
            }
            catch (IOException ex) {
                throw new CredentialRetrievalException(ex);
            }
        };
    }

    public CredentialRetriever inferCredentialHelper() {
        ArrayList<String> inferredCredentialHelperSuffixes = new ArrayList<String>();
        for (String registrySuffix : COMMON_CREDENTIAL_HELPERS.keySet()) {
            if (!this.imageReference.getRegistry().endsWith(registrySuffix)) continue;
            String inferredCredentialHelperSuffix = (String)COMMON_CREDENTIAL_HELPERS.get((Object)registrySuffix);
            if (inferredCredentialHelperSuffix == null) {
                throw new IllegalStateException("No COMMON_CREDENTIAL_HELPERS should be null");
            }
            inferredCredentialHelperSuffixes.add(inferredCredentialHelperSuffix);
        }
        return () -> {
            for (String inferredCredentialHelperSuffix : inferredCredentialHelperSuffixes) {
                try {
                    return Optional.of(this.retrieveFromDockerCredentialHelper(Paths.get("docker-credential-" + inferredCredentialHelperSuffix, new String[0])));
                }
                catch (CredentialHelperNotFoundException | CredentialHelperUnhandledServerUrlException ex) {
                    if (ex.getMessage() == null) continue;
                    this.dispatchEvent(LogEvent.info(ex.getMessage()));
                    if (ex.getCause() == null || ex.getCause().getMessage() == null) continue;
                    this.dispatchEvent(LogEvent.info("  Caused by: " + ex.getCause().getMessage()));
                }
                catch (IOException ex) {
                    throw new CredentialRetrievalException(ex);
                }
            }
            return Optional.empty();
        };
    }

    public CredentialRetriever dockerConfig() {
        return this.dockerConfig(new DockerConfigCredentialRetriever(this.imageReference.getRegistry()));
    }

    public CredentialRetriever dockerConfig(Path dockerConfigFile) {
        return this.dockerConfig(new DockerConfigCredentialRetriever(this.imageReference.getRegistry(), dockerConfigFile));
    }

    @VisibleForTesting
    CredentialRetriever dockerConfig(DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        return () -> {
            try {
                Optional<Credential> dockerConfigCredentials = dockerConfigCredentialRetriever.retrieve(this.eventDispatcher);
                if (dockerConfigCredentials.isPresent()) {
                    this.dispatchEvent(LogEvent.info("Using credentials from Docker config for " + this.imageReference.getRegistry()));
                    return dockerConfigCredentials;
                }
            }
            catch (IOException ex) {
                this.dispatchEvent(LogEvent.info("Unable to parse Docker config"));
            }
            return Optional.empty();
        };
    }

    private Credential retrieveFromDockerCredentialHelper(Path credentialHelper) throws CredentialHelperUnhandledServerUrlException, CredentialHelperNotFoundException, IOException {
        Credential credentials = this.dockerCredentialHelperFactory.create(this.imageReference.getRegistry(), credentialHelper).retrieve();
        this.logGotCredentialsFrom(credentialHelper.getFileName().toString());
        return credentials;
    }

    private void logGotCredentialsFrom(String credentialSource) {
        this.dispatchEvent(LogEvent.info("Using " + credentialSource + " for " + this.imageReference.getRegistry()));
    }

    private void dispatchEvent(JibEvent jibEvent) {
        if (this.eventDispatcher == null) {
            return;
        }
        this.eventDispatcher.dispatch(jibEvent);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface DockerCredentialHelperFactory {
        public DockerCredentialHelper create(String var1, Path var2);
    }
}

