/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.registry.RegistryAliasGroup;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ImageReference {
    private static final String DOCKER_HUB_REGISTRY = "registry-1.docker.io";
    private static final String DEFAULT_TAG = "latest";
    private static final String LIBRARY_REPOSITORY_PREFIX = "library/";
    private static final String REGISTRY_COMPONENT_REGEX = "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))";
    private static final String REGISTRY_REGEX = String.format("%s(?:\\.%s)*(?::\\d+)?", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))");
    private static final String REPOSITORY_COMPONENT_REGEX = "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*";
    private static final String REPOSITORY_REGEX = String.format("(?:%s/)*%s", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*");
    private static final String TAG_REGEX = "[\\w][\\w.-]{0,127}";
    private static final String REFERENCE_REGEX = String.format("^(?:(%s)/)?(%s)(?:(?::(%s))|(?:@(%s)))?$", REGISTRY_REGEX, REPOSITORY_REGEX, "[\\w][\\w.-]{0,127}", DescriptorDigest.DIGEST_REGEX);
    private static final Pattern REFERENCE_PATTERN = Pattern.compile(REFERENCE_REGEX);
    private final String registry;
    private final String repository;
    private final String tag;

    public static ImageReference parse(String reference) throws InvalidImageReferenceException {
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        if (!matcher.find() || matcher.groupCount() < 4) {
            throw new InvalidImageReferenceException(reference);
        }
        String registry = matcher.group(1);
        String repository = matcher.group(2);
        String tag = matcher.group(3);
        String digest = matcher.group(4);
        if (Strings.isNullOrEmpty((String)registry)) {
            registry = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)repository)) {
            throw new InvalidImageReferenceException(reference);
        }
        if (!(registry.contains(".") || registry.contains(":") || "localhost".equals(registry))) {
            repository = registry + "/" + repository;
            registry = DOCKER_HUB_REGISTRY;
        }
        if (DOCKER_HUB_REGISTRY.equals(registry) && repository.indexOf(47) < 0) {
            repository = LIBRARY_REPOSITORY_PREFIX + repository;
        }
        if (!Strings.isNullOrEmpty((String)tag)) {
            if (!Strings.isNullOrEmpty((String)digest)) {
                throw new InvalidImageReferenceException(reference);
            }
        } else {
            tag = !Strings.isNullOrEmpty((String)digest) ? digest : DEFAULT_TAG;
        }
        return new ImageReference(registry, repository, tag);
    }

    public static ImageReference of(@Nullable String registry, String repository, @Nullable String tag) {
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)registry) || ImageReference.isValidRegistry(registry) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)ImageReference.isValidRepository(repository));
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)tag) || ImageReference.isValidTag(tag) ? 1 : 0) != 0);
        if (Strings.isNullOrEmpty((String)registry)) {
            registry = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)tag)) {
            tag = DEFAULT_TAG;
        }
        return new ImageReference(registry, repository, tag);
    }

    public static ImageReference scratch() {
        return new ImageReference("", "scratch", "");
    }

    public static boolean isValidRegistry(String registry) {
        return registry.matches(REGISTRY_REGEX);
    }

    public static boolean isValidRepository(String repository) {
        return repository.matches(REPOSITORY_REGEX);
    }

    public static boolean isValidTag(String tag) {
        return tag.matches(TAG_REGEX) || tag.matches(DescriptorDigest.DIGEST_REGEX);
    }

    public static boolean isDefaultTag(String tag) {
        return tag.isEmpty() || DEFAULT_TAG.equals(tag);
    }

    private ImageReference(String registry, String repository, String tag) {
        this.registry = RegistryAliasGroup.getHost(registry);
        this.repository = repository;
        this.tag = tag;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean usesDefaultTag() {
        return ImageReference.isDefaultTag(this.tag);
    }

    public boolean isTagDigest() {
        return this.tag.matches(DescriptorDigest.DIGEST_REGEX);
    }

    public boolean isScratch() {
        return "".equals(this.registry) && "scratch".equals(this.repository) && "".equals(this.tag);
    }

    public ImageReference withTag(String newTag) {
        return ImageReference.of(this.registry, this.repository, newTag);
    }

    public String toString() {
        StringBuilder referenceString = new StringBuilder();
        if (!DOCKER_HUB_REGISTRY.equals(this.registry)) {
            referenceString.append(this.registry).append('/').append(this.repository);
        } else if (this.repository.startsWith(LIBRARY_REPOSITORY_PREFIX)) {
            referenceString.append(this.repository.substring(LIBRARY_REPOSITORY_PREFIX.length()));
        } else {
            referenceString.append(this.repository);
        }
        if (!DEFAULT_TAG.equals(this.tag)) {
            referenceString.append(this.isTagDigest() ? (char)'@' : ':').append(this.tag);
        }
        return referenceString.toString();
    }

    public String toStringWithTag() {
        return this + (this.usesDefaultTag() ? ":latest" : "");
    }
}

