/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.function.BiFunction;

public class LayerEntry {
    public static final BiFunction<Path, AbsoluteUnixPath, FilePermissions> DEFAULT_FILE_PERMISSIONS_PROVIDER = (sourcePath, destinationPath) -> Files.isDirectory(sourcePath, new LinkOption[0]) ? FilePermissions.DEFAULT_FOLDER_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS;
    public static final Instant DEFAULT_MODIFIED_TIME = Instant.ofEpochSecond(1L);
    public static final BiFunction<Path, AbsoluteUnixPath, Instant> DEFAULT_MODIFIED_TIME_PROVIDER = (sourcePath, destinationPath) -> DEFAULT_MODIFIED_TIME;
    private final Path sourceFile;
    private final AbsoluteUnixPath extractionPath;
    private final FilePermissions permissions;
    private final Instant lastModifiedTime;

    public LayerEntry(Path sourceFile, AbsoluteUnixPath extractionPath) {
        this(sourceFile, extractionPath, DEFAULT_FILE_PERMISSIONS_PROVIDER.apply(sourceFile, extractionPath));
    }

    public LayerEntry(Path sourceFile, AbsoluteUnixPath extractionPath, FilePermissions permissions) {
        this(sourceFile, extractionPath, permissions, DEFAULT_MODIFIED_TIME_PROVIDER.apply(sourceFile, extractionPath));
    }

    public LayerEntry(Path sourceFile, AbsoluteUnixPath extractionPath, FilePermissions permissions, Instant lastModifiedTime) {
        this.sourceFile = sourceFile;
        this.extractionPath = extractionPath;
        this.permissions = permissions;
        this.lastModifiedTime = lastModifiedTime;
    }

    public Instant getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public AbsoluteUnixPath getExtractionPath() {
        return this.extractionPath;
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayerEntry)) {
            return false;
        }
        LayerEntry otherLayerEntry = (LayerEntry)other;
        return this.sourceFile.equals(otherLayerEntry.sourceFile) && this.extractionPath.equals(otherLayerEntry.extractionPath) && Objects.equals(this.permissions, otherLayerEntry.permissions) && Objects.equals(this.lastModifiedTime, otherLayerEntry.lastModifiedTime);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.extractionPath, this.permissions, this.lastModifiedTime);
    }
}

