/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.event.DefaultEventDispatcher;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.ImageFormat;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.maven.DecryptedMavenSettings;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenRawConfiguration;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.maven.ProxyProvider;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsRunner;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildImageMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "build";
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build image failed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return;
        }
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        if (Arrays.stream(ImageFormat.values()).noneMatch(value -> value.name().equals(this.getFormat()))) {
            throw new MojoFailureException("<format> parameter is configured with value '" + this.getFormat() + "', but the only valid configuration options are '" + (Object)((Object)ImageFormat.Docker) + "' and '" + (Object)((Object)ImageFormat.OCI) + "'.");
        }
        if (Strings.isNullOrEmpty((String)this.getTargetImage())) {
            throw new MojoFailureException(HelpfulSuggestions.forToNotConfigured("Missing target image parameter", "<to><image>", "pom.xml", "mvn compile jib:build -Dimage=<your image name>"));
        }
        try {
            MavenRawConfiguration mavenRawConfiguration = new MavenRawConfiguration(this);
            AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(mavenRawConfiguration, MojoCommon.isWarProject(this.getProject()));
            MavenProjectProperties projectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getSession(), this.getLog(), appRoot);
            DefaultEventDispatcher eventDispatcher = new DefaultEventDispatcher(projectProperties.getEventHandlers());
            DecryptedMavenSettings decryptedSettings = DecryptedMavenSettings.from(this.getSession().getSettings(), this.getSettingsDecrypter());
            PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfigurationForRegistryImage(mavenRawConfiguration, new MavenSettingsServerCredentials(decryptedSettings), projectProperties);
            ProxyProvider.init(decryptedSettings);
            ImageReference targetImageReference = pluginConfigurationProcessor.getTargetImageReference();
            HelpfulSuggestions helpfulSuggestions = new MavenHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this).setBaseImageReference(pluginConfigurationProcessor.getBaseImageReference()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(targetImageReference).setTargetImageHasConfiguredCredentials(pluginConfigurationProcessor.isTargetImageCredentialPresent()).build();
            Path buildOutput = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
            try {
                BuildStepsRunner.forBuildImage(targetImageReference, this.getTargetImageAdditionalTags()).writeImageDigest(buildOutput.resolve("jib-image.digest")).writeImageId(buildOutput.resolve("jib-image.id")).build(pluginConfigurationProcessor.getJibContainerBuilder(), pluginConfigurationProcessor.getContainerizer(), eventDispatcher, helpfulSuggestions);
            }
            finally {
                projectProperties.waitForLoggingThread();
                this.getLog().info((CharSequence)"");
            }
        }
        catch (InvalidAppRootException ex) {
            throw new MojoExecutionException("<container><appRoot> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new MojoExecutionException("<container><workingDirectory> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new MojoExecutionException("<container><volumes> is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Exception)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forIncompatibleBaseImageJavaVesionForMaven(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Exception)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Exception)ex);
        }
        catch (CacheDirectoryCreationException | MainClassInferenceException | IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        catch (BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
    }
}

