/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

class DecryptedMavenSettings {
    private final SettingsDecryptionResult result;
    private final Settings settings;

    static DecryptedMavenSettings from(Settings settings, SettingsDecrypter decryptor) throws MojoExecutionException {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(settings);
        SettingsDecryptionResult result = decryptor.decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
            throw new MojoExecutionException("Unable to decrypt settings.xml: " + problem);
        }
        return new DecryptedMavenSettings(result, settings);
    }

    private DecryptedMavenSettings(SettingsDecryptionResult result, Settings settings) {
        this.result = result;
        this.settings = settings;
    }

    List<Server> getServers() {
        return this.result.getServers().isEmpty() ? this.settings.getServers() : this.result.getServers();
    }

    List<Proxy> getProxies() {
        return this.result.getProxies().isEmpty() ? this.settings.getProxies() : this.result.getProxies();
    }
}

