/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.maven.DecryptedMavenSettings;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.settings.Server;

class MavenSettingsServerCredentials
implements Function<String, Optional<AuthProperty>> {
    static final String CREDENTIAL_SOURCE = "Maven settings";
    private final DecryptedMavenSettings settings;

    MavenSettingsServerCredentials(DecryptedMavenSettings settings) {
        this.settings = settings;
    }

    @Override
    public Optional<AuthProperty> apply(String registry) {
        Predicate<Server> idMatches = server -> registry.equals(server.getId());
        Optional<Server> server2 = this.settings.getServers().stream().filter(idMatches).findFirst();
        if (!server2.isPresent()) {
            return Optional.empty();
        }
        final String username = server2.get().getUsername();
        final String password = server2.get().getPassword();
        return Optional.of(new AuthProperty(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public String getPassword() {
                return password;
            }

            @Override
            public String getAuthDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }

            @Override
            public String getUsernameDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }

            @Override
            public String getPasswordDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }
        });
    }
}

