/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.plugins.common.SkaffoldFilesOutput;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;

@Mojo(name="_skaffold-files-v2", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, aggregator=true)
public class FilesMojoV2
extends AbstractMojo {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-files-v2";
    @Nullable
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Nullable
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    private final SkaffoldFilesOutput skaffoldFilesOutput = new SkaffoldFilesOutput();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Preconditions.checkNotNull(this.projects);
        Preconditions.checkNotNull((Object)this.session);
        Preconditions.checkNotNull((Object)this.projectDependenciesResolver);
        for (MavenProject project : this.projects) {
            this.skaffoldFilesOutput.addBuild(project.getFile().toPath());
            if ("pom".equals(project.getPackaging())) continue;
            this.skaffoldFilesOutput.addInput(Paths.get(project.getBuild().getSourceDirectory(), new String[0]));
            project.getBuild().getResources().stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).forEach(this.skaffoldFilesOutput::addInput);
            if (project.getPlugin("com.google.cloud.tools:jib-maven-plugin") != null) {
                this.skaffoldFilesOutput.addInput(this.resolveExtraDirectory(project));
            }
            Set projectArtifacts = this.projects.stream().map(MavenProject::getArtifact).map(Object::toString).collect(Collectors.toSet());
            DependencyFilter ignoreProjectDependenciesFilter = (node, parents) -> {
                if (node == null || node.getDependency() == null) {
                    return false;
                }
                if (projectArtifacts.contains(node.getArtifact().toString())) {
                    return false;
                }
                return "compile+runtime".contains(node.getDependency().getScope());
            };
            try {
                DependencyResolutionResult resolutionResult = this.projectDependenciesResolver.resolve(new DefaultDependencyResolutionRequest(project, this.session.getRepositorySession()).setResolutionFilter(ignoreProjectDependenciesFilter));
                resolutionResult.getDependencies().stream().map(Dependency::getArtifact).filter(Artifact::isSnapshot).map(Artifact::getFile).map(File::toPath).forEach(this.skaffoldFilesOutput::addInput);
            }
            catch (DependencyResolutionException ex) {
                throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)ex));
            }
        }
        try {
            System.out.println("\nBEGIN JIB JSON");
            System.out.println(this.skaffoldFilesOutput.getJsonString());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private Path resolveExtraDirectory(MavenProject project) {
        Xpp3Dom extraDirectoryConfiguration;
        Xpp3Dom pluginConfiguration;
        String extraDirectoryProperty = MavenProjectProperties.getProperty("jib.extraDirectory.path", project, this.session);
        if (extraDirectoryProperty != null) {
            return Paths.get(extraDirectoryProperty, new String[0]);
        }
        Plugin jibMavenPlugin = project.getPlugin("com.google.cloud.tools:jib-maven-plugin");
        if (jibMavenPlugin != null && (pluginConfiguration = (Xpp3Dom)jibMavenPlugin.getConfiguration()) != null && (extraDirectoryConfiguration = pluginConfiguration.getChild("extraDirectory")) != null) {
            Xpp3Dom child = extraDirectoryConfiguration.getChild("path");
            if (child != null) {
                return Paths.get(child.getValue(), new String[0]);
            }
            return Paths.get(extraDirectoryConfiguration.getValue(), new String[0]);
        }
        return ((MavenProject)Preconditions.checkNotNull((Object)project)).getBasedir().getAbsoluteFile().toPath().resolve("src").resolve("main").resolve("jib");
    }
}

