/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpHostConnectException;

public class BuildStepsRunner {
    private static final String STARTUP_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY = "Containerizing application to ";
    private static final String SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY = "Built and pushed image as ";
    private static final String STARTUP_MESSAGE_PREFIX_FOR_DOCKER_DAEMON = "Containerizing application to Docker daemon as ";
    private static final String SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_DAEMON = "Built image to Docker daemon as ";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_TARBALL = "Containerizing application to file at '%s'...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_TARBALL = "Built image tarball at \u001b[36m%s\u001b[0m";
    private final String startupMessage;
    private final String successMessage;
    @Nullable
    private Path imageDigestOutputPath;
    @Nullable
    private Path imageIdOutputPath;

    private static CharSequence colorCyan(CharSequence innerText) {
        return new StringBuilder().append("\u001b[36m").append(innerText).append("\u001b[0m");
    }

    private static String buildMessageWithTargetImageReferences(ImageReference targetImageReference, Set<String> additionalTags, String prefix, String suffix) {
        StringJoiner successMessageBuilder = new StringJoiner(", ", prefix, suffix);
        successMessageBuilder.add(BuildStepsRunner.colorCyan(targetImageReference.toString()));
        for (String tag : additionalTags) {
            successMessageBuilder.add(BuildStepsRunner.colorCyan(targetImageReference.withTag(tag).toString()));
        }
        return successMessageBuilder.toString();
    }

    public static BuildStepsRunner forBuildImage(ImageReference targetImageReference, Set<String> additionalTags) {
        return new BuildStepsRunner(BuildStepsRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, STARTUP_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY, "..."), BuildStepsRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY, ""));
    }

    public static BuildStepsRunner forBuildToDockerDaemon(ImageReference targetImageReference, Set<String> additionalTags) {
        return new BuildStepsRunner(BuildStepsRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, STARTUP_MESSAGE_PREFIX_FOR_DOCKER_DAEMON, "..."), BuildStepsRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_DAEMON, ""));
    }

    public static BuildStepsRunner forBuildTar(Path outputPath) {
        return new BuildStepsRunner(String.format(STARTUP_MESSAGE_FORMAT_FOR_TARBALL, outputPath.toString()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_TARBALL, outputPath.toString()));
    }

    private static void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpStatusCodeForbidden(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
        }
        throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialsDefined(registryUnauthorizedException.getRegistry(), registryUnauthorizedException.getRepository()), registryUnauthorizedException);
    }

    @VisibleForTesting
    BuildStepsRunner(String startupMessage, String successMessage) {
        this.startupMessage = startupMessage;
        this.successMessage = successMessage;
    }

    public JibContainer build(JibContainerBuilder jibContainerBuilder, Containerizer containerizer, EventDispatcher eventDispatcher, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException, IOException, CacheDirectoryCreationException {
        try {
            eventDispatcher.dispatch(LogEvent.lifecycle(""));
            eventDispatcher.dispatch(LogEvent.lifecycle(this.startupMessage));
            JibContainer jibContainer = jibContainerBuilder.containerize(containerizer);
            eventDispatcher.dispatch(LogEvent.lifecycle(""));
            eventDispatcher.dispatch(LogEvent.lifecycle(this.successMessage));
            if (this.imageDigestOutputPath != null) {
                String imageDigest = jibContainer.getDigest().toString();
                Files.write(this.imageDigestOutputPath, imageDigest.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            if (this.imageIdOutputPath != null) {
                String imageId = jibContainer.getImageId().toString();
                Files.write(this.imageIdOutputPath, imageId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            return jibContainer;
        }
        catch (HttpHostConnectException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpHostConnect(), ex);
        }
        catch (RegistryUnauthorizedException ex) {
            BuildStepsRunner.handleRegistryUnauthorizedException(ex, helpfulSuggestions);
        }
        catch (RegistryCredentialsNotSentException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotSent(), ex);
        }
        catch (RegistryAuthenticationFailedException ex) {
            if (ex.getCause() instanceof HttpResponseException) {
                BuildStepsRunner.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(ex.getServerUrl(), ex.getImageName(), (HttpResponseException)ex.getCause()), helpfulSuggestions);
            }
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), ex);
        }
        catch (UnknownHostException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forUnknownHost(), ex);
        }
        catch (InsecureRegistryException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forInsecureRegistry(), ex);
        }
        catch (RegistryException ex) {
            String message = (String)Verify.verifyNotNull((Object)ex.getMessage());
            throw new BuildStepsExecutionException(message, ex);
        }
        catch (ExecutionException ex) {
            String message = (String)Verify.verifyNotNull((Object)ex.getCause().getMessage());
            throw new BuildStepsExecutionException(message, ex.getCause());
        }
        catch (InterruptedException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), ex);
        }
        throw new IllegalStateException("unreachable");
    }

    public BuildStepsRunner writeImageDigest(@Nullable Path imageDigestOutputPath) {
        this.imageDigestOutputPath = imageDigestOutputPath;
        return this;
    }

    public BuildStepsRunner writeImageId(@Nullable Path imageIdOutputPath) {
        this.imageIdOutputPath = imageIdOutputPath;
        return this;
    }
}

