/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.filesystem.RelativeUnixPath;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class JavaContainerBuilderHelper {
    public static LayerConfiguration extraDirectoryLayerConfiguration(Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions) throws IOException {
        LayerConfiguration.Builder builder = LayerConfiguration.builder().setName(JavaContainerBuilder.LayerType.EXTRA_FILES.getName());
        new DirectoryWalker(extraDirectory).filterRoot().walk(localPath -> {
            AbsoluteUnixPath pathOnContainer = AbsoluteUnixPath.get("/").resolve(extraDirectory.relativize(localPath));
            FilePermissions permissions = (FilePermissions)extraDirectoryPermissions.get(pathOnContainer);
            if (permissions == null) {
                builder.addEntry(localPath, pathOnContainer);
            } else {
                builder.addEntry(localPath, pathOnContainer, permissions);
            }
        });
        return builder.build();
    }

    public static JibContainerBuilder fromExplodedWar(RegistryImage baseImage, Path explodedWar, AbsoluteUnixPath appRoot) throws IOException {
        Path webInfLib = explodedWar.resolve("WEB-INF/lib");
        Path webInfClasses = explodedWar.resolve("WEB-INF/classes");
        Predicate<Path> isDependency = path -> path.startsWith(webInfLib);
        Predicate<Path> isClassFile = path -> path.startsWith(webInfClasses) && path.getFileName().toString().endsWith(".class");
        Predicate<Path> isResource = isDependency.or(isClassFile).negate();
        JavaContainerBuilder javaContainerBuilder = JavaContainerBuilder.from(baseImage).setAppRoot(appRoot).setResourcesDestination(RelativeUnixPath.get("")).setClassesDestination(RelativeUnixPath.get("WEB-INF/classes")).setDependenciesDestination(RelativeUnixPath.get("WEB-INF/lib"));
        if (Files.exists(explodedWar, new LinkOption[0])) {
            javaContainerBuilder.addResources(explodedWar, isResource);
        }
        if (Files.exists(webInfClasses, new LinkOption[0])) {
            javaContainerBuilder.addClasses(webInfClasses, isClassFile);
        }
        if (Files.exists(webInfLib, new LinkOption[0])) {
            javaContainerBuilder.addDependencies((List<Path>)new DirectoryWalker(webInfLib).filterRoot().walk());
        }
        return javaContainerBuilder.toContainerBuilder();
    }

    private JavaContainerBuilderHelper() {
    }
}

