/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.event.DefaultEventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.frontend.MainClassFinder;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;

public class MainClassResolver {
    public static String resolveMainClass(@Nullable String mainClass, ProjectProperties projectProperties) throws MainClassInferenceException, IOException {
        if (mainClass == null) {
            mainClass = MainClassResolver.getMainClassFromJar(projectProperties);
        }
        if (mainClass == null) {
            mainClass = MainClassResolver.findMainClassInClassFiles(projectProperties);
        } else if (!MainClassResolver.isValidJavaClass(mainClass)) {
            try {
                mainClass = MainClassResolver.findMainClassInClassFiles(projectProperties);
            }
            catch (MainClassInferenceException mainClassInferenceException) {
                // empty catch block
            }
        }
        Preconditions.checkNotNull((Object)mainClass);
        if (!MainClassResolver.isValidJavaClass(mainClass)) {
            new DefaultEventDispatcher(projectProperties.getEventHandlers()).dispatch(LogEvent.warn("'mainClass' is not a valid Java class : " + mainClass));
        }
        return mainClass;
    }

    @VisibleForTesting
    static boolean isValidJavaClass(String className) {
        for (String part : Splitter.on((char)'.').split((CharSequence)className)) {
            if (SourceVersion.isIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getMainClassFromJar(ProjectProperties projectProperties) {
        new DefaultEventDispatcher(projectProperties.getEventHandlers()).dispatch(LogEvent.info("Searching for main class... Add a 'mainClass' configuration to '" + projectProperties.getPluginName() + "' to improve build speed."));
        return projectProperties.getMainClassFromJar();
    }

    private static String findMainClassInClassFiles(ProjectProperties projectProperties) throws MainClassInferenceException, IOException {
        new DefaultEventDispatcher(projectProperties.getEventHandlers()).dispatch(LogEvent.debug("Could not find a valid main class specified in " + projectProperties.getJarPluginName() + "; attempting to infer main class."));
        MainClassFinder.Result mainClassFinderResult = new MainClassFinder(projectProperties.getClassFiles(), new DefaultEventDispatcher(projectProperties.getEventHandlers())).find();
        switch (mainClassFinderResult.getType()) {
            case MAIN_CLASS_FOUND: {
                return mainClassFinderResult.getFoundMainClass();
            }
            case MAIN_CLASS_NOT_FOUND: {
                throw new MainClassInferenceException(HelpfulSuggestions.forMainClassNotFound("Main class was not found", projectProperties.getPluginName()));
            }
            case MULTIPLE_MAIN_CLASSES: {
                throw new MainClassInferenceException(HelpfulSuggestions.forMainClassNotFound("Multiple valid main classes were found: " + String.join((CharSequence)", ", mainClassFinderResult.getFoundMainClasses()), projectProperties.getPluginName()));
            }
        }
        throw new IllegalStateException("Cannot reach here");
    }

    private MainClassResolver() {
    }
}

